/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.WhiteSpaceProcessor;
import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.EventArg;
import com.sun.xml.bind.v2.TODO;
import com.sun.xml.bind.v2.runtime.AbstractUnmarshallingEventHandlerImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.UnmarshallingEventHandler;
import com.sun.xml.bind.v2.runtime.property.Messages;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class Unmarshaller {
    public static final Handler ERROR = new Handler(){

        protected Handler forwardTo(EventType event) {
            return this;
        }

        public void text(UnmarshallingContext context, CharSequence s) throws SAXException {
            if (WhiteSpaceProcessor.isWhiteSpace(s)) {
                return;
            }
            super.text(context, s);
        }
    };
    public static final Handler REVERT_TO_PARENT = new RevertToParentHandler();

    private Unmarshaller() {
    }

    public static final class SpawnNewChildHandler
    extends SpawnChildHandler {
        public SpawnNewChildHandler(JaxBeanInfo target, Handler next, boolean childAsElement) {
            super(target, next, childAsElement);
        }

        public void onNewChild(Object bean, Object value, UnmarshallingContext context) {
            this.targetBeanInfo.getUnmarshaller(false);
        }
    }

    public static final class XsiNilHandler
    extends EpsilonHandler {
        private final Handler endElement;
        private final Accessor acc;
        private final Handler next;

        public XsiNilHandler(Handler next, Handler ee, Accessor acc) {
            this.next = next;
            this.endElement = ee;
            this.acc = acc;
        }

        protected void handle(UnmarshallingContext context) throws SAXException {
            String value;
            int idx = context.getAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil");
            if (idx != -1 && DatatypeConverterImpl._parseBoolean(value = context.eatAttribute(idx))) {
                try {
                    this.acc.set(context.getTarget(), null);
                }
                catch (AccessorException e) {
                    XsiNilHandler.handleGenericException(context, e, true);
                }
                context.setCurrentHandler(this.endElement);
                return;
            }
            context.setCurrentHandler(this.next);
        }
    }

    public static final class SpawnChildSetHandler
    extends SpawnChildHandler {
        private final Accessor acc;

        public SpawnChildSetHandler(JaxBeanInfo target, Handler next, boolean childAsElement, Accessor acc) {
            super(target, next, childAsElement);
            this.acc = acc;
        }

        protected void onNewChild(Object bean, Object value, UnmarshallingContext context) throws AccessorException {
            this.acc.set(bean, value);
        }
    }

    public static abstract class SpawnChildHandler
    extends EpsilonHandler {
        protected final JaxBeanInfo targetBeanInfo;
        private final Handler next;
        private boolean childAsElement;

        public SpawnChildHandler(JaxBeanInfo target, Handler next, boolean childAsElement) {
            this.next = next;
            this.targetBeanInfo = target;
            this.childAsElement = childAsElement;
        }

        public void leaveChild(UnmarshallingContext context, Object child) throws SAXException {
            try {
                this.onNewChild(context.getTarget(), child, context);
            }
            catch (AccessorException e) {
                SpawnChildHandler.handleGenericException(context, e);
            }
            context.setCurrentHandler(this.next);
        }

        protected void handle(UnmarshallingContext context) throws SAXException {
            int idx = context.getAttribute("http://www.w3.org/2001/XMLSchema-instance", "type");
            JaxBeanInfo beanInfo = this.targetBeanInfo;
            if (idx >= 0) {
                String value = context.eatAttribute(idx);
                QName type = DatatypeConverterImpl._parseQName(value, context);
                if (type == null) {
                    SpawnChildHandler.reportError(context, Messages.NOT_A_QNAME.format(value), true);
                } else {
                    beanInfo = context.getJAXBContext().getGlobalType(type);
                    if (beanInfo == null) {
                        SpawnChildHandler.reportError(context, Messages.UNRECOGNIZED_TYPE_NAME.format(value), true);
                        beanInfo = this.targetBeanInfo;
                    }
                }
            }
            this.spawnChild(context, beanInfo, this.childAsElement);
        }

        protected abstract void onNewChild(Object var1, Object var2, UnmarshallingContext var3) throws AccessorException, SAXException;
    }

    private static final class RevertToParentHandler
    extends EpsilonHandler {
        private RevertToParentHandler() {
        }

        public void handle(UnmarshallingContext context) throws SAXException {
            context.popContentHandler();
        }
    }

    public static final class TextHandler
    extends RawTextHandler {
        private final TransducedAccessor acc;

        public TextHandler(TransducedAccessor acc, Handler fallthrough, Handler next) {
            super(fallthrough, next);
            this.acc = acc;
            assert (acc != null);
        }

        public void processText(UnmarshallingContext context, CharSequence s) throws SAXException {
            try {
                this.acc.parse(context.getTarget(), s, context);
            }
            catch (AccessorException e) {
                TextHandler.handleGenericException(context, e, true);
            }
            catch (RuntimeException e) {
                TextHandler.handleParseConversionException(context, e);
            }
        }

        public String toString() {
            return "TextHandler " + this.acc.toString();
        }
    }

    public static abstract class RawTextHandler
    extends ForkHandler {
        public RawTextHandler(Handler fallthrough, Handler next) {
            super(fallthrough, next);
        }

        public final void text(UnmarshallingContext context, CharSequence s) throws SAXException {
            this.processText(context, s);
            context.setCurrentHandler(this.next);
        }

        public abstract void processText(UnmarshallingContext var1, CharSequence var2) throws SAXException;

        protected Handler forwardTo(EventType event) {
            if (event == EventType.TEXT) {
                return this;
            }
            return super.forwardTo(event);
        }
    }

    public static class LeaveElementHandler
    extends ForkHandler {
        public LeaveElementHandler(Handler fallthrough, Handler next) {
            super(fallthrough, next);
        }

        public void leaveElement(UnmarshallingContext context, EventArg arg) throws SAXException {
            context.popAttributes();
            context.setCurrentHandler(this.next);
        }

        protected Handler forwardTo(EventType event) {
            if (event == EventType.LEAVE_ELEMENT) {
                return this;
            }
            return super.forwardTo(event);
        }

        public String toString() {
            return "LeaveElement@" + System.identityHashCode(this);
        }
    }

    public static class EnterElementHandler
    extends ForkHandler {
        private final Name name;
        private final boolean collectText;

        public EnterElementHandler(Name name, boolean elementOnly, Handler fallthrough, Handler next) {
            super(fallthrough, next);
            this.name = name;
            this.collectText = !elementOnly;
        }

        public void text(UnmarshallingContext context, CharSequence s) throws SAXException {
            this.next.text(context, s);
        }

        public void enterElement(UnmarshallingContext context, EventArg arg) throws SAXException {
            if (arg.matches(this.name)) {
                context.pushAttributes(arg.atts, this.collectText);
                this.act(context);
                return;
            }
            this.next.enterElement(context, arg);
        }

        protected void act(UnmarshallingContext context) throws SAXException {
            context.setCurrentHandler(this.next);
        }

        protected Handler forwardTo(EventType event) {
            if (event == EventType.ENTER_ELEMENT) {
                return this;
            }
            return super.forwardTo(event);
        }

        public String toString() {
            return "EnterElementHandler " + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AttributeWildcardHandler
    extends AttributeHandler {
        private final Accessor acc;

        public AttributeWildcardHandler(Accessor<?, Map<QName, Object>> acc, Handler fallthrough) {
            super(fallthrough, fallthrough);
            this.acc = acc;
            assert (acc != null);
        }

        @Override
        protected boolean checkAttribute(UnmarshallingContext context) throws SAXException {
            int i;
            Attributes atts = context.getUnconsumedAttributes();
            for (i = 0; i < atts.getLength(); ++i) {
                String auri = atts.getURI(i);
                String alocal = atts.getLocalName(i);
                String aqname = atts.getQName(i);
                String avalue = atts.getValue(auri, alocal);
                try {
                    this.processValue(context, auri, alocal, aqname, avalue);
                    continue;
                }
                catch (AccessorException e) {
                    AttributeWildcardHandler.handleGenericException(context, e, true);
                }
            }
            for (i = atts.getLength() - 1; i >= 0; --i) {
                context.eatAttribute(i);
            }
            return false;
        }

        @Override
        public void processValue(UnmarshallingContext context, String nsUri, String local, String qname, String value) throws AccessorException {
            int idx;
            Object o = context.getTarget();
            HashMap<QName, String> map = (HashMap<QName, String>)this.acc.get(o);
            if (map == null) {
                TODO.checkSpec("Is this behavior described in the spec?");
                map = new HashMap<QName, String>();
                this.acc.set(o, map);
            }
            String prefix = (idx = qname.indexOf(58)) < 0 ? "" : qname.substring(0, idx);
            TODO.prototype();
            map.put(new QName(nsUri, local, prefix), value);
        }
    }

    public static abstract class SingleAttributeHandler
    extends AttributeHandler {
        public final Name name;

        public SingleAttributeHandler(Name name, Handler fallthrough, Handler next) {
            super(fallthrough, next);
            this.name = name;
        }

        protected boolean checkAttribute(UnmarshallingContext context) throws SAXException {
            int idx = context.getAttribute(this.name);
            if (idx != -1) {
                String qname = context.getUnconsumedAttributes().getQName(idx);
                String value = context.eatAttribute(idx);
                try {
                    this.processValue(context, this.name.nsUri, this.name.localName, qname, value);
                }
                catch (AccessorException e) {
                    SingleAttributeHandler.handleGenericException(context, e, true);
                }
                catch (RuntimeException e) {
                    SingleAttributeHandler.handleParseConversionException(context, e);
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class AttributeHandler
    extends EpsilonHandler {
        private final Handler next;
        private final Handler fallthrough;

        protected AttributeHandler(Handler fallthrough, Handler next) {
            this.fallthrough = fallthrough;
            this.next = next;
        }

        public void handle(UnmarshallingContext context) throws SAXException {
            if (this.checkAttribute(context)) {
                context.setCurrentHandler(this.next);
            } else {
                context.setCurrentHandler(this.fallthrough);
            }
        }

        protected abstract boolean checkAttribute(UnmarshallingContext var1) throws SAXException;

        public abstract void processValue(UnmarshallingContext var1, String var2, String var3, String var4, String var5) throws AccessorException, SAXException;
    }

    public static class ForkHandler
    extends DelegatingHandler {
        public Handler next;

        public ForkHandler(Handler fallthrough, Handler next) {
            super(fallthrough);
            this.next = next;
        }
    }

    public static class DelegatingHandler
    extends Handler {
        private Handler delegateEnterElement;
        private Handler delegateLeaveElement;
        private Handler delegateText;
        private Handler fallthrough;

        protected DelegatingHandler(Handler fallthrough) {
            if (fallthrough != null) {
                this.setFallthrough(fallthrough);
            }
        }

        protected final void setFallthrough(Handler fallthrough) {
            this.fallthrough = fallthrough;
            this.delegateEnterElement = fallthrough.forwardTo(EventType.ENTER_ELEMENT);
            this.delegateLeaveElement = fallthrough.forwardTo(EventType.LEAVE_ELEMENT);
            this.delegateText = fallthrough.forwardTo(EventType.TEXT);
        }

        public void enterElement(UnmarshallingContext context, EventArg arg) throws SAXException {
            this.delegateEnterElement.enterElement(context, arg);
        }

        public void leaveElement(UnmarshallingContext context, EventArg arg) throws SAXException {
            this.delegateLeaveElement.leaveElement(context, arg);
        }

        public void text(UnmarshallingContext context, CharSequence s) throws SAXException {
            this.delegateText.text(context, s);
        }

        protected Handler forwardTo(EventType event) {
            switch (event) {
                case ENTER_ELEMENT: {
                    return this.delegateEnterElement;
                }
                case LEAVE_ELEMENT: {
                    return this.delegateLeaveElement;
                }
                case TEXT: {
                    return this.delegateText;
                }
            }
            assert (false);
            return null;
        }
    }

    public static abstract class EpsilonHandler
    extends Handler {
        protected EpsilonHandler() {
        }

        protected Handler forwardTo(EventType event) {
            return this;
        }

        public void activate(UnmarshallingContext context) throws SAXException {
            this.handle(context);
        }

        public void enterElement(UnmarshallingContext context, EventArg arg) throws SAXException {
            this._handle(context).enterElement(context, arg);
        }

        public void leaveElement(UnmarshallingContext context, EventArg arg) throws SAXException {
            this._handle(context).leaveElement(context, arg);
        }

        public void text(UnmarshallingContext context, CharSequence s) throws SAXException {
            this._handle(context).text(context, s);
        }

        private UnmarshallingEventHandler _handle(UnmarshallingContext context) throws SAXException {
            this.handle(context);
            return context.getCurrentHandler();
        }

        protected abstract void handle(UnmarshallingContext var1) throws SAXException;
    }

    public static abstract class Handler
    extends AbstractUnmarshallingEventHandlerImpl {
        protected Handler() {
        }

        protected abstract Handler forwardTo(EventType var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ENTER_ELEMENT,
        LEAVE_ELEMENT,
        TEXT;

    }
}

