/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.QNameMap;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.core.TypeRef;
import com.sun.xml.bind.v2.model.runtime.RuntimeElementPropertyInfo;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.property.SingleLeafProperty;
import com.sun.xml.bind.v2.runtime.property.Unmarshaller;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleElementLeafProperty<BeanT>
extends SingleLeafProperty<BeanT> {
    private final Name tagName;
    private final boolean nillable;
    private final Accessor acc;

    public SingleElementLeafProperty(JAXBContextImpl context, RuntimeElementPropertyInfo prop) {
        super(context, prop);
        TypeRef ref = prop.getTypes().get(0);
        this.tagName = context.nameBuilder.createElementName(ref.getTagName());
        assert (this.tagName != null);
        this.nillable = ref.isNillable();
        this.acc = prop.getAccessor().optimize();
    }

    @Override
    public void serializeBody(BeanT o, XMLSerializer w) throws SAXException, AccessorException, IOException, XMLStreamException {
        boolean hasValue = this.xacc.hasValue(o);
        if (hasValue) {
            this.xacc.writeLeafElement(o, this.tagName, this.fieldName, w);
        } else if (this.nillable) {
            w.startElement(this.tagName, null);
            w.writeXsiNilTrue();
            w.endElement();
        }
    }

    @Override
    public Unmarshaller.Handler createUnmarshallerHandler(JAXBContextImpl grammar, Unmarshaller.Handler tail) {
        Unmarshaller.Handler cont = tail;
        Unmarshaller.LeaveElementHandler ee = new Unmarshaller.LeaveElementHandler(Unmarshaller.ERROR, tail);
        Unmarshaller.TextHandler text = new Unmarshaller.TextHandler(this.xacc, Unmarshaller.ERROR, ee);
        tail = this.nillable ? new Unmarshaller.XsiNilHandler(text, ee, this.acc) : text;
        tail = new Unmarshaller.EnterElementHandler(this.tagName, false, cont, tail);
        return tail;
    }

    @Override
    public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<Unmarshaller.Handler> handlers) {
        Unmarshaller.Handler tail;
        chain.tail = tail = this.createUnmarshallerHandler(chain.context, chain.tail);
        handlers.put(this.tagName, tail);
    }

    @Override
    public PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    @Override
    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        if (this.tagName.equals(nsUri, localName)) {
            return this.acc;
        }
        return null;
    }
}

