/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.v2.EventArg;
import com.sun.xml.bind.v2.QNameMap;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.property.ChildElementUnmarshallerBuilder;
import com.sun.xml.bind.v2.runtime.property.Unmarshaller;
import com.sun.xml.bind.v2.runtime.property.UnmarshallerChain;
import java.util.List;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDispatcher
extends Unmarshaller.DelegatingHandler {
    private final QNameMap<Unmarshaller.Handler> childUnmarshallers = new QNameMap();
    private final Unmarshaller.Handler catchAll;
    private final Unmarshaller.RawTextHandler textHandler;
    private final int frameSize;

    public ElementDispatcher(JAXBContextImpl context, List<? extends ChildElementUnmarshallerBuilder> properties, Unmarshaller.Handler fallthrough) {
        super(fallthrough);
        UnmarshallerChain chain = new UnmarshallerChain(context);
        for (ChildElementUnmarshallerBuilder childElementUnmarshallerBuilder : properties) {
            chain.tail = Unmarshaller.REVERT_TO_PARENT;
            childElementUnmarshallerBuilder.buildChildElementUnmarshallers(chain, this.childUnmarshallers);
        }
        this.frameSize = chain.getScopeSize();
        this.textHandler = (Unmarshaller.RawTextHandler)this.childUnmarshallers.get(ChildElementUnmarshallerBuilder.TEXT_HANDLER);
        this.catchAll = this.childUnmarshallers.get(ChildElementUnmarshallerBuilder.CATCH_ALL);
    }

    @Override
    public void text(UnmarshallingContext context, CharSequence s) throws SAXException {
        if (this.textHandler == null) {
            return;
        }
        if (context.getCurrentHandler() != this) {
            context.setCurrentHandler(this);
        }
        this.textHandler.processText(context, s);
    }

    @Override
    protected Unmarshaller.Handler forwardTo(Unmarshaller.EventType event) {
        if (event == Unmarshaller.EventType.ENTER_ELEMENT) {
            return this;
        }
        if (event == Unmarshaller.EventType.TEXT) {
            return this;
        }
        return super.forwardTo(event);
    }

    @Override
    public void enterElement(UnmarshallingContext context, EventArg arg) throws SAXException {
        Unmarshaller.Handler handler = this.childUnmarshallers.get(arg.uri, arg.local);
        if (handler == null && (handler = this.catchAll) == null) {
            this.unexpectedEnterElement(context, arg);
            return;
        }
        if (context.getCurrentHandler() != this) {
            context.setCurrentHandler(this);
        }
        context.pushContentHandler(handler, context.getTarget(), false);
        context.getCurrentHandler().enterElement(context, arg);
    }

    @Override
    public void activate(UnmarshallingContext context) throws SAXException {
        context.startScope(this.frameSize);
    }

    @Override
    public void deactivated(UnmarshallingContext context) throws SAXException {
        context.endScope(this.frameSize);
        super.deactivated(context);
    }

    public String toString() {
        return "ElementDispatcher " + this.childUnmarshallers.toString();
    }
}

