/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.output.Encoded;
import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.bind.v2.runtime.output.XmlOutput;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class UTF8XmlOutput
extends XmlOutput {
    protected final OutputStream out;
    private Encoded[] prefixes = new Encoded[8];
    private final Encoded[] localNames;
    private final Encoded textBuffer = new Encoded();
    private static final byte[] XMLNS_EQUALS = UTF8XmlOutput.toBytes(" xmlns=\"");
    private static final byte[] XMLNS_COLON = UTF8XmlOutput.toBytes(" xmlns:");
    private static final byte[] EQUALS = UTF8XmlOutput.toBytes("=\"");
    private static final byte[] CLOSE_TAG = UTF8XmlOutput.toBytes("</");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final byte[] XML_DECL = UTF8XmlOutput.toBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");

    public UTF8XmlOutput(OutputStream out, Encoded[] localNames) {
        this.out = out;
        this.localNames = localNames;
        for (int i = 0; i < this.prefixes.length; ++i) {
            this.prefixes[i] = new Encoded();
        }
        this.prefixes[0].set("xml:");
    }

    public void startDocument(boolean fragment) throws IOException, SAXException, XMLStreamException {
        if (!fragment) {
            this.out.write(XML_DECL);
        }
    }

    public void endDocument(boolean fragment) throws IOException, SAXException, XMLStreamException {
        this.out.write(10);
    }

    public void beginStartTag(int prefix, String localName) throws IOException {
        int base = this.pushNsDecls();
        this.out.write(60);
        this.writeName(prefix, localName);
        this.writeNsDecls(base);
    }

    public void beginStartTag(Name name) throws IOException {
        int base = this.pushNsDecls();
        this.out.write(60);
        this.writeName(name);
        this.writeNsDecls(base);
    }

    private int pushNsDecls() {
        int i;
        int total = this.nsContext.count();
        NamespaceContextImpl.Element ns = this.nsContext.getCurrent();
        if (total > this.prefixes.length) {
            int m = Math.max(total, this.prefixes.length * 2);
            Encoded[] buf = new Encoded[m];
            System.arraycopy(this.prefixes, 0, buf, 0, this.prefixes.length);
            for (i = this.prefixes.length; i < buf.length; ++i) {
                buf[i] = new Encoded();
            }
            this.prefixes = buf;
        }
        int count = ns.count();
        int base = ns.getBase();
        for (i = 0; i < count; ++i) {
            String p = ns.getPrefix(i);
            Encoded e = this.prefixes[base + i];
            if (p.length() == 0) {
                e.buf = EMPTY_BYTE_ARRAY;
                e.len = 0;
                continue;
            }
            e.set(p);
            e.append(':');
        }
        return base;
    }

    private void writeNsDecls(int base) throws IOException {
        NamespaceContextImpl.Element ns = this.nsContext.getCurrent();
        int count = ns.count();
        for (int i = 0; i < count; ++i) {
            String p = ns.getPrefix(i);
            if (p.length() == 0) {
                if (base == 1 && ns.getNsUri(i).length() == 0) continue;
                this.out.write(XMLNS_EQUALS);
            } else {
                Encoded e = this.prefixes[base + i];
                this.out.write(XMLNS_COLON);
                this.out.write(e.buf, 0, e.len - 1);
                this.out.write(EQUALS);
            }
            this.text(ns.getNsUri(i));
            this.out.write(34);
        }
    }

    private void writePrefix(int prefix) throws IOException {
        Encoded e = this.prefixes[prefix];
        this.out.write(e.buf, 0, e.len);
    }

    private void writeName(Name name) throws IOException {
        this.writePrefix(this.nsUriIndex2prefixIndex[name.nsUriIndex]);
        this.localNames[name.localNameIndex].write(this.out);
    }

    private void writeName(int prefix, String localName) throws IOException {
        this.writePrefix(prefix);
        this.textBuffer.set(localName);
        this.textBuffer.write(this.out);
    }

    public void attribute(Name name, String value) throws IOException {
        this.out.write(32);
        if (name.nsUriIndex == -1) {
            this.localNames[name.localNameIndex].write(this.out);
        } else {
            this.writeName(name);
        }
        this.out.write(EQUALS);
        this.text(value);
        this.out.write(34);
    }

    public void attribute(int prefix, String localName, String value) throws IOException {
        this.out.write(32);
        if (prefix == -1) {
            this.textBuffer.set(localName);
            this.textBuffer.write(this.out);
        } else {
            this.writeName(prefix, localName);
        }
        this.out.write(EQUALS);
        this.text(value);
        this.out.write(34);
    }

    public void attribute(Name name, char[] buf, int len, boolean needEscape) throws IOException {
        this.out.write(32);
        if (name.nsUriIndex == -1) {
            this.textBuffer.set(name.localName);
            this.textBuffer.write(this.out);
        } else {
            this.writeName(name);
        }
        this.out.write(EQUALS);
        this.text(buf, len);
        this.out.write(34);
    }

    public void endStartTag() throws IOException {
        this.out.write(62);
    }

    public void endTag(Name name) throws IOException {
        this.out.write(CLOSE_TAG);
        this.writeName(name);
        this.out.write(62);
    }

    public void endTag(int prefix, String localName) throws IOException {
        this.out.write(CLOSE_TAG);
        this.writeName(prefix, localName);
        this.out.write(62);
    }

    public void text(String value, boolean needSP) throws IOException {
        if (needSP) {
            this.out.write(32);
        }
        this.text(value);
    }

    private void text(String value) throws IOException {
        this.textBuffer.setEscape(value);
        this.textBuffer.write(this.out);
    }

    public void text(char[] buf, int len) throws IOException {
        this.textBuffer.setEscape(buf, len);
        this.textBuffer.write(this.out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    static final byte[] toBytes(String s) {
        byte[] buf = new byte[s.length()];
        for (int i = s.length() - 1; i >= 0; --i) {
            buf[i] = (byte)s.charAt(i);
        }
        return buf;
    }
}

