/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.output.Encoded;
import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import java.io.IOException;
import java.io.OutputStream;

public class IndentingUTF8XmlOutput
extends UTF8XmlOutput {
    private final Encoded indent;
    private int depth = 0;
    private boolean seenText = false;

    public IndentingUTF8XmlOutput(OutputStream out, String indentStr, Encoded[] localNames) {
        super(out, localNames);
        this.indent = indentStr != null ? new Encoded(indentStr) : null;
    }

    public void beginStartTag(int prefix, String localName) throws IOException {
        this.indentStartTag();
        super.beginStartTag(prefix, localName);
    }

    public void beginStartTag(Name name) throws IOException {
        this.indentStartTag();
        super.beginStartTag(name);
    }

    private void indentStartTag() throws IOException {
        if (!this.seenText) {
            this.printIndent();
        }
        ++this.depth;
        this.seenText = false;
    }

    public void endTag(Name name) throws IOException {
        this.indentEndTag();
        super.endTag(name);
    }

    public void endTag(int prefix, String localName) throws IOException {
        this.indentEndTag();
        super.endTag(prefix, localName);
    }

    private void indentEndTag() throws IOException {
        --this.depth;
        if (!this.seenText) {
            this.printIndent();
        }
        this.seenText = false;
    }

    private void printIndent() throws IOException {
        this.out.write(10);
        for (int i = this.depth; i > 0; --i) {
            this.indent.write(this.out);
        }
    }

    public void text(String value, boolean needSP) throws IOException {
        this.seenText = true;
        super.text(value, needSP);
    }

    public void text(char[] buf, int len) throws IOException {
        this.seenText = true;
        super.text(buf, len);
    }
}

