/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.xml.bind.annotation.DomHandler;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.serializer.Util;
import com.sun.xml.bind.util.ValidationEventLocatorExImpl;
import com.sun.xml.bind.v2.runtime.ContentHandlerAdaptor;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.MarshallerImpl;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.NameList;
import com.sun.xml.bind.v2.runtime.NamespaceContext2;
import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.bind.v2.runtime.output.XmlOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLSerializer
implements ValidationEventHandler {
    public final JAXBContextImpl grammar;
    private Object currentTarget;
    public XmlOutput out;
    public final NameList nameList;
    public final int[] knownUri2prefixIndexMap;
    private final NamespaceContextImpl nsContext;
    private NamespaceContextImpl.Element nse;
    private boolean textHasAlreadyPrinted = false;
    private boolean seenRoot = false;
    private final MarshallerImpl marshaller;
    private final Set<Object> idReferencedObjects = new HashSet<Object>();
    private final Set<Object> objectsWithId = new HashSet<Object>();
    private String schemaLocation;
    private String noNsSchemaLocation;
    private Transformer identityTransformer;
    private ContentHandlerAdaptor contentHandlerAdapter;
    private char[] textBuf = new char[128];
    private int textBufLen = 0;
    private boolean inAttribute;

    XMLSerializer(MarshallerImpl _owner) {
        this.marshaller = _owner;
        this.grammar = this.marshaller.context;
        this.nsContext = new NamespaceContextImpl(this);
        this.nameList = this.marshaller.context.nameList;
        this.knownUri2prefixIndexMap = new int[this.nameList.namespaceURIs.length];
    }

    protected final String getIdFromObject(Object identifiableObject) throws SAXException, JAXBException {
        return this.grammar.getBeanInfo(identifiableObject, true).getId(identifiableObject, this);
    }

    protected void handleMissingObjectError(String fieldName) throws SAXException, IOException, XMLStreamException {
        this.reportMissingObjectError(fieldName);
        this.endNamespaceDecls();
        this.endAttributes();
    }

    public void reportError(ValidationEvent ve) throws AbortSerializationException {
        ValidationEventHandler handler;
        try {
            handler = this.marshaller.getEventHandler();
        }
        catch (JAXBException e) {
            throw new AbortSerializationException((Exception)((Object)e));
        }
        if (!handler.handleEvent(ve)) {
            if (ve.getLinkedException() instanceof Exception) {
                throw new AbortSerializationException((Exception)ve.getLinkedException());
            }
            throw new AbortSerializationException(ve.getMessage());
        }
    }

    public final void reportError(String fieldName, Throwable t) throws AbortSerializationException {
        ValidationEventImpl ve = new ValidationEventImpl(1, t.getMessage(), (ValidationEventLocator)new ValidationEventLocatorExImpl(this.currentTarget, fieldName), t);
        this.reportError((ValidationEvent)ve);
    }

    public void startElement(Name tagName, Object outerPeer) {
        this.startElement();
        this.nse.setTagName(tagName);
    }

    public void startElement(String nsUri, String localName, String preferredPrefix, Object outerPeer) {
        this.startElement();
        int idx = this.nsContext.declareNsUri(nsUri, preferredPrefix, false);
        this.nse.setTagName(idx, localName);
    }

    public void endNamespaceDecls() throws IOException, XMLStreamException {
        this.nsContext.collectionMode = false;
        this.nse.startElement(this.out);
    }

    public void endAttributes() throws SAXException, IOException, XMLStreamException {
        if (!this.seenRoot) {
            this.seenRoot = true;
            if (this.schemaLocation != null || this.noNsSchemaLocation != null) {
                int p = this.nsContext.getPrefixIndex("http://www.w3.org/2001/XMLSchema-instance");
                if (this.schemaLocation != null) {
                    this.out.attribute(p, "schemaLocation", this.schemaLocation);
                }
                if (this.noNsSchemaLocation != null) {
                    this.out.attribute(p, "noNamespaceSchemaLocation", this.noNsSchemaLocation);
                }
            }
        }
        this.out.endStartTag();
    }

    public void endElement() throws SAXException, IOException, XMLStreamException {
        this.nse.endElement(this.out);
        this.nse = this.nse.pop();
        this.textHasAlreadyPrinted = false;
    }

    public void leafElement(Name tagName, String data, String fieldName) throws SAXException, IOException, XMLStreamException {
        if (this.seenRoot) {
            this.textHasAlreadyPrinted = false;
            this.nse = this.nse.push();
            this.out.beginStartTag(tagName);
            this.out.endStartTag();
            this.out.text(data, false);
            this.out.endTag(tagName);
            this.nse = this.nse.pop();
        } else {
            this.startElement(tagName, null);
            this.endNamespaceDecls();
            this.endAttributes();
            this.out.text(data, false);
            this.endElement();
        }
    }

    public void text(String text, String fieldName) throws SAXException, IOException, XMLStreamException {
        if (text == null) {
            this.reportMissingObjectError(fieldName);
            return;
        }
        if (this.inAttribute) {
            int len = text.length();
            if (this.textBufLen > 0) {
                this.ensureTextBuffer(len + 1);
                this.textBuf[this.textBufLen++] = 32;
            } else {
                this.ensureTextBuffer(len);
            }
            text.getChars(0, len, this.textBuf, this.textBufLen);
            this.textBufLen += len;
        } else {
            this.out.text(text, this.textHasAlreadyPrinted);
            this.textHasAlreadyPrinted = true;
        }
    }

    public void startAttribute() {
        this.textBufLen = 0;
        assert (!this.inAttribute);
        this.inAttribute = true;
    }

    public void endAttribute(Name name) throws IOException, XMLStreamException {
        assert (this.inAttribute);
        this.inAttribute = false;
        this.out.attribute(name, this.textBuf, this.textBufLen, true);
    }

    public void attribute(String uri, String local, String value) throws SAXException {
        int prefix = uri.length() == 0 ? -1 : this.nsContext.getPrefixIndex(uri);
        try {
            this.out.attribute(prefix, local, value);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void attribute(Name name, String value) throws IOException, XMLStreamException {
        this.out.attribute(name, value);
    }

    public NamespaceContext2 getNamespaceContext() {
        return this.nsContext;
    }

    public String onID(Object owner, String value) {
        this.objectsWithId.add(owner);
        return value;
    }

    public String onIDREF(Object obj) throws SAXException {
        String id;
        try {
            id = this.getIdFromObject(obj);
        }
        catch (JAXBException e) {
            this.reportError(null, e);
            return null;
        }
        this.idReferencedObjects.add(obj);
        if (id == null) {
            this.reportError((ValidationEvent)new NotIdentifiableEventImpl(1, Messages.format("SAXMarshaller.NotIdentifiable"), (ValidationEventLocator)new ValidationEventLocatorImpl(obj)));
        }
        return id;
    }

    public final void childAsSoleContent(Object child, String fieldName) throws SAXException, IOException, XMLStreamException {
        if (child == null) {
            this.handleMissingObjectError(fieldName);
        } else {
            JaxBeanInfo beanInfo;
            try {
                beanInfo = this.grammar.getBeanInfo(child, true);
            }
            catch (JAXBException e) {
                this.reportError(fieldName, e);
                this.endNamespaceDecls();
                this.endAttributes();
                return;
            }
            Object oldTarget = this.currentTarget;
            this.currentTarget = child;
            beanInfo.serializeURIs(child, this);
            this.endNamespaceDecls();
            beanInfo.serializeAttributes(child, this);
            this.endAttributes();
            beanInfo.serializeBody(child, this);
            this.currentTarget = oldTarget;
        }
    }

    public final void childAsXsiType(Object child, String fieldName, JaxBeanInfo expected) throws SAXException, IOException, XMLStreamException {
        if (child == null) {
            this.handleMissingObjectError(fieldName);
        } else {
            boolean asExpected = child.getClass() == expected.jaxbType;
            JaxBeanInfo actual = expected;
            Object oldTarget = this.currentTarget;
            this.currentTarget = child;
            if (!asExpected) {
                try {
                    actual = this.grammar.getBeanInfo(child, true);
                }
                catch (JAXBException e) {
                    this.reportError(fieldName, e);
                    this.endNamespaceDecls();
                    this.endAttributes();
                    return;
                }
                if (actual == expected) {
                    asExpected = true;
                } else {
                    this.getNamespaceContext().declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
                    this.getNamespaceContext().declareNamespace(actual.typeName.getNamespaceURI(), null, false);
                }
            }
            actual.serializeURIs(child, this);
            this.endNamespaceDecls();
            if (!asExpected) {
                this.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", DatatypeConverter.printQName((QName)actual.typeName, (NamespaceContext)this.getNamespaceContext()));
            }
            actual.serializeAttributes(child, this);
            this.endAttributes();
            actual.serializeBody(child, this);
            this.currentTarget = oldTarget;
        }
    }

    public void attWildcardAsURIs(Map<QName, Object> attributes, String fieldName) {
        for (Map.Entry<QName, Object> e : attributes.entrySet()) {
            QName n = e.getKey();
            String nsUri = n.getNamespaceURI();
            if (nsUri.length() <= 0) continue;
            String p = n.getPrefix();
            if (p.length() == 0) {
                p = null;
            }
            this.nsContext.declareNsUri(nsUri, p, true);
        }
    }

    public void attWildcardAsAttributes(Map<QName, Object> attributes, String fieldName) throws SAXException {
        for (Map.Entry<QName, Object> e : attributes.entrySet()) {
            QName n = e.getKey();
            this.attribute(n.getNamespaceURI(), n.getLocalPart(), e.getValue().toString());
        }
    }

    public final void writeXsiNilTrue() throws SAXException, IOException, XMLStreamException {
        this.getNamespaceContext().declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
        this.endNamespaceDecls();
        this.attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        this.endAttributes();
    }

    public <E> void writeDom(E element, DomHandler<E, ?> domHandler, Object parentBean, String fieldName) throws SAXException {
        Source source = domHandler.marshal(element, this);
        if (this.identityTransformer == null) {
            this.identityTransformer = JAXBContextImpl.createTransformer();
        }
        if (this.contentHandlerAdapter == null) {
            this.contentHandlerAdapter = new ContentHandlerAdaptor(this);
        }
        try {
            this.identityTransformer.transform(source, new SAXResult(this.contentHandlerAdapter));
        }
        catch (TransformerException e) {
            this.reportError(fieldName, e);
        }
    }

    public void setPrefixMapper(NamespacePrefixMapper prefixMapper) {
        this.nsContext.setPrefixMapper(prefixMapper);
    }

    public void prepare(XmlOutput out, String schemaLocation, String noNsSchemaLocation) {
        this.nsContext.reset();
        this.nse = this.nsContext.getCurrent().push();
        this.out = out;
        out.nsUriIndex2prefixIndex = this.knownUri2prefixIndexMap;
        out.nsContext = this.nsContext;
        this.objectsWithId.clear();
        this.idReferencedObjects.clear();
        this.textBufLen = 0;
        this.textHasAlreadyPrinted = false;
        this.inAttribute = false;
        this.seenRoot = false;
        this.schemaLocation = schemaLocation;
        this.noNsSchemaLocation = noNsSchemaLocation;
    }

    public void addInscopeBinding(String nsUri, String prefix) {
        this.nsContext.declareNsUri(nsUri, prefix, false);
    }

    private void startElement() {
        this.nse = this.nse.push();
        if (!this.seenRoot) {
            String[] knownUris = this.nameList.namespaceURIs;
            for (int i = 0; i < knownUris.length; ++i) {
                this.knownUri2prefixIndexMap[i] = this.nsContext.declareNsUri(knownUris[i], null, false);
            }
            String[] uris = this.nsContext.getPrefixMapper().getPreDeclaredNamespaceUris();
            if (uris != null) {
                for (String uri : uris) {
                    if (uri == null) continue;
                    this.nsContext.declareNsUri(uri, null, false);
                }
            }
            if (this.schemaLocation != null || this.noNsSchemaLocation != null) {
                this.nsContext.declareNsUri("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
            }
        }
        this.nsContext.collectionMode = true;
        this.textHasAlreadyPrinted = false;
    }

    private void ensureTextBuffer(int cap) {
        int sz = this.textBufLen + cap;
        if (sz > this.textBuf.length) {
            sz = Math.max(sz, this.textBuf.length * 2);
            char[] buf = new char[sz];
            System.arraycopy(this.textBuf, 0, buf, 0, this.textBufLen);
            this.textBuf = buf;
        }
    }

    void reconcileID() throws SAXException {
        this.idReferencedObjects.removeAll(this.objectsWithId);
        for (Object idObj : this.idReferencedObjects) {
            try {
                String id = this.getIdFromObject(idObj);
                this.reportError((ValidationEvent)new NotIdentifiableEventImpl(1, Messages.format("SAXMarshaller.DanglingIDREF", id), (ValidationEventLocator)new ValidationEventLocatorImpl(idObj)));
            }
            catch (JAXBException jAXBException) {}
        }
        this.idReferencedObjects.clear();
        this.objectsWithId.clear();
    }

    public boolean handleEvent(ValidationEvent event) {
        try {
            return this.marshaller.getEventHandler().handleEvent(event);
        }
        catch (JAXBException e) {
            throw new Error(e);
        }
    }

    private void reportMissingObjectError(String fieldName) throws SAXException {
        this.reportError(Util.createMissingObjectError(this.currentTarget, fieldName));
    }
}

