/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2;

import java.util.ArrayList;
import java.util.HashSet;

class NameUtil {
    private static HashSet<String> reservedKeywords = new HashSet();

    NameUtil() {
    }

    protected boolean isPunct(char c) {
        return c == '-' || c == '.' || c == ':' || c == '_' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
    }

    protected boolean isDigit(char c) {
        return c >= '0' && c <= '9' || Character.isDigit(c);
    }

    protected boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z' || Character.isUpperCase(c);
    }

    protected boolean isLower(char c) {
        return c >= 'a' && c <= 'z' || Character.isLowerCase(c);
    }

    protected boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    public String capitalize(String s) {
        if (!this.isLower(s.charAt(0))) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        sb.append(Character.toUpperCase(s.charAt(0)));
        sb.append(s.substring(1).toLowerCase());
        return sb.toString();
    }

    protected int nextBreak(String s, int start) {
        int n = s.length();
        for (int i = start; i < n; ++i) {
            char c0 = s.charAt(i);
            if (i >= n - 1) continue;
            char c1 = s.charAt(i + 1);
            if (this.isPunct(c1)) {
                return i + 1;
            }
            if (this.isDigit(c0) && !this.isDigit(c1)) {
                return i + 1;
            }
            if (!this.isDigit(c0) && this.isDigit(c1)) {
                return i + 1;
            }
            if (this.isLower(c0) && !this.isLower(c1)) {
                return i + 1;
            }
            if (this.isLetter(c0) && !this.isLetter(c1)) {
                return i + 1;
            }
            if (!this.isLetter(c0) && this.isLetter(c1)) {
                return i + 1;
            }
            if (i >= n - 2) continue;
            char c2 = s.charAt(i + 2);
            if (!this.isUpper(c0) || !this.isUpper(c1) || !this.isLower(c2)) continue;
            return i + 1;
        }
        return -1;
    }

    public String[] toWordList(String s) {
        ArrayList<String> ss = new ArrayList<String>();
        int n = s.length();
        int i = 0;
        while (i < n) {
            while (i < n && this.isPunct(s.charAt(i))) {
                ++i;
            }
            if (i >= n) break;
            int b = this.nextBreak(s, i);
            String w = b == -1 ? s.substring(i) : s.substring(i, b);
            ss.add(NameUtil.escape(this.capitalize(w)));
            if (b == -1) break;
            i = b;
        }
        return ss.toArray(new String[0]);
    }

    protected String toMixedCaseName(String[] ss, boolean startUpper) {
        StringBuilder sb = new StringBuilder();
        if (ss.length > 0) {
            sb.append(startUpper ? ss[0] : ss[0].toLowerCase());
            for (int i = 1; i < ss.length; ++i) {
                sb.append(ss[i]);
            }
        }
        return sb.toString();
    }

    protected String toMixedCaseVariableName(String[] ss, boolean startUpper, boolean cdrUpper) {
        if (cdrUpper) {
            for (int i = 1; i < ss.length; ++i) {
                ss[i] = this.capitalize(ss[i]);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (ss.length > 0) {
            sb.append(startUpper ? ss[0] : ss[0].toLowerCase());
            for (int i = 1; i < ss.length; ++i) {
                sb.append(ss[i]);
            }
        }
        return sb.toString();
    }

    public String toConstantName(String s) {
        return this.toConstantName(this.toWordList(s));
    }

    public String toConstantName(String[] ss) {
        StringBuilder sb = new StringBuilder();
        if (ss.length > 0) {
            sb.append(ss[0].toUpperCase());
            for (int i = 1; i < ss.length; ++i) {
                sb.append('_');
                sb.append(ss[i].toUpperCase());
            }
        }
        return sb.toString();
    }

    public static void escape(StringBuilder sb, String s, int start) {
        int n = s.length();
        for (int i = start; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            if (c <= '\u000f') {
                sb.append("000");
            } else if (c <= '\u00ff') {
                sb.append("00");
            } else if (c <= '\u0fff') {
                sb.append('0');
            }
            sb.append(Integer.toString(c, 16));
        }
    }

    private static String escape(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            StringBuilder sb = new StringBuilder(s.substring(0, i));
            NameUtil.escape(sb, s, i);
            return sb.toString();
        }
        return s;
    }

    public static boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (reservedKeywords.contains(s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaPackageName(String s) {
        while (s.length() != 0) {
            int idx = s.indexOf(46);
            if (idx == -1) {
                idx = s.length();
            }
            if (!NameUtil.isJavaIdentifier(s.substring(0, idx))) {
                return false;
            }
            if ((s = s.substring(idx)).length() == 0) continue;
            s = s.substring(1);
        }
        return true;
    }

    static {
        String[] words = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"};
        for (int i = 0; i < words.length; ++i) {
            reservedKeywords.add(words[i]);
        }
    }
}

