/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2;

import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.bind.v2.Messages;
import com.sun.xml.bind.v2.model.annotation.RuntimeInlineAnnotationReader;
import com.sun.xml.bind.v2.model.core.Ref;
import com.sun.xml.bind.v2.model.impl.RuntimeModelBuilder;
import com.sun.xml.bind.v2.model.runtime.RuntimeTypeInfoSet;
import com.sun.xml.bind.v2.runtime.IllegalAnnotationsException;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextFactory {
    public static JAXBContext createContext(Class[] classes, Map<String, Object> properties) throws JAXBException {
        properties = properties == null ? Collections.emptyMap() : new HashMap<String, Object>(properties);
        String defaultNsUri = ContextFactory.getDefaultNamespaceRemap(properties);
        if (!properties.isEmpty()) {
            throw new JAXBException(Messages.UNSUPPORTED_PROPERTY.format(properties.keySet().iterator().next()));
        }
        return ContextFactory.createContext(classes, Collections.<TypeReference>emptyList(), defaultNsUri);
    }

    private static String getDefaultNamespaceRemap(Map<String, Object> properties) throws JAXBException {
        String propName = null;
        Object o = properties.get("com.sun.xml.bind.defaultNamespaceRemap");
        if (o != null) {
            properties.remove("com.sun.xml.bind.defaultNamespaceRemap");
            if (!(o instanceof String)) {
                throw new JAXBException(Messages.INVALID_PROPERTY_VALUE.format("com.sun.xml.bind.defaultNamespaceRemap", o));
            }
            propName = (String)o;
        }
        return propName;
    }

    public static JAXBContext createContext(Class[] classes, Collection<TypeReference> typeRefs, String defaultNsUri) throws JAXBException {
        if (defaultNsUri == null) {
            defaultNsUri = "";
        }
        RuntimeModelBuilder builder = new RuntimeModelBuilder(new RuntimeInlineAnnotationReader(), defaultNsUri);
        IllegalAnnotationsException.Builder errorHandler = new IllegalAnnotationsException.Builder();
        builder.setErrorHandler(errorHandler);
        for (Class c : classes) {
            builder.getTypeInfo(new Ref(c));
        }
        RuntimeTypeInfoSet r = builder.link();
        errorHandler.check();
        assert (r != null) : "if no error was reported, the link must be a success";
        return new JAXBContextImpl(r, typeRefs);
    }

    public static JAXBContext createContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        ArrayList<Class> classes = new ArrayList<Class>();
        StringTokenizer tokens = new StringTokenizer(contextPath, ":");
        while (tokens.hasMoreTokens()) {
            List<Class> indexedClasses;
            boolean foundJaxbIndex = false;
            boolean foundObjectFactory = false;
            String pkg = tokens.nextToken();
            try {
                Class<?> o = classLoader.loadClass(pkg + ".ObjectFactory");
                classes.add(o);
                foundObjectFactory = true;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                indexedClasses = ContextFactory.loadIndexedClasses(pkg, classLoader);
            }
            catch (IOException e) {
                throw new JAXBException((Throwable)e);
            }
            if (indexedClasses != null) {
                classes.addAll(indexedClasses);
                foundJaxbIndex = true;
            }
            if (foundObjectFactory || foundJaxbIndex) continue;
            throw new JAXBException(Messages.BROKEN_CONTEXTPATH.format(pkg));
        }
        return ContextFactory.createContext(classes.toArray(new Class[classes.size()]), properties);
    }

    private static List<Class> loadIndexedClasses(String pkg, ClassLoader classLoader) throws IOException, JAXBException {
        String resource = pkg.replace('.', '/') + "/jaxb.index";
        InputStream resourceAsStream = classLoader.getResourceAsStream(resource);
        if (resourceAsStream == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream, "UTF-8"));
        ArrayList<Class> classes = new ArrayList<Class>();
        String className = in.readLine();
        while (className != null) {
            if ((className = className.trim()).startsWith("#") || className.length() == 0) {
                className = in.readLine();
                continue;
            }
            int dot = className.indexOf(46);
            if (dot < 1) {
                throw new JAXBException(Messages.ILLEGAL_ENTRY.format(resource));
            }
            className = className.substring(0, dot);
            try {
                classes.add(classLoader.loadClass(pkg + '.' + className));
            }
            catch (ClassNotFoundException e) {
                throw new JAXBException(Messages.ERROR_LOADING_CLASS.format(className, resource));
            }
            className = in.readLine();
        }
        return classes;
    }
}

