/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.TODO;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassFactory {
    private static final Class[] emptyClass;
    private static final Object[] emptyObject;
    private static final Logger logger;
    private static final ThreadLocal<Map<Class, Constructor>> tls;

    public static <T> T create0(Class<T> clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Map<Class, Constructor> m = tls.get();
        Constructor<T> cons = m.get(clazz);
        if (cons == null) {
            try {
                cons = clazz.getDeclaredConstructor(emptyClass);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.INFO, "No default constructor found on " + clazz, e);
                throw new NoSuchMethodError(e.getMessage());
            }
            int classMod = clazz.getModifiers();
            if (!Modifier.isPublic(classMod) || !Modifier.isPublic(cons.getModifiers())) {
                try {
                    cons.setAccessible(true);
                }
                catch (SecurityException e) {
                    logger.log(Level.FINE, "Unable to make the constructor of " + clazz + " accessible", e);
                    throw e;
                }
            }
            m.put(clazz, cons);
        }
        return cons.newInstance(emptyObject);
    }

    public static <T> T create(Class<T> clazz) {
        try {
            return ClassFactory.create0(clazz);
        }
        catch (InstantiationException e) {
            logger.log(Level.INFO, "failed to create a new instance of " + clazz, e);
            throw new InstantiationError(e.toString());
        }
        catch (IllegalAccessException e) {
            logger.log(Level.INFO, "failed to create a new instance of " + clazz, e);
            throw new IllegalAccessError(e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new IllegalStateException(target);
        }
    }

    static {
        TODO.prototype();
        emptyClass = new Class[0];
        emptyObject = new Object[0];
        logger = Util.getClassLogger();
        tls = new ThreadLocal<Map<Class, Constructor>>(){

            @Override
            public Map<Class, Constructor> initialValue() {
                return new WeakHashMap<Class, Constructor>();
            }
        };
    }
}

