/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.taskchain;

import co.aikar.taskchain.TaskChain;
import co.aikar.taskchain.TaskChainFactory;
import co.aikar.taskchain.TaskChainUtil;

public class TaskChainExample {
    public static void example(TaskChainFactory factory) {
        TaskChainUtil.log("Starting example");
        TaskChain chain = factory.newSharedChain("TEST");
        chain.delay(60).sync(() -> {
            Object test = chain.setTaskData("test", 1);
            TaskChainUtil.log("==> 1st test");
        }).delay(20).async(() -> {
            Object test = chain.getTaskData("test");
            TaskChainUtil.log("==> 2nd test: " + test + " = should be 1");
        }).sync(TaskChain::abort).execute(finished -> TaskChainUtil.log("first test finished: " + finished));
        factory.getImplementation().postAsync(() -> {
            TaskChain chain2 = factory.newSharedChain("TEST");
            chain2.sync(() -> {
                Object test = chain2.getTaskData("test");
                TaskChainUtil.log("==> 3rd test: " + test + " = should be null");
            }).delay(20).current(() -> TaskChainUtil.log("test 2nd chain 20 ticks later")).execute(finished -> TaskChainUtil.log("second test finished: " + finished));
            factory.newSharedChain("TEST").async(() -> TaskChainUtil.log("==> 4th test - should print")).returnData("notthere").abortIfNull().syncLast(val -> TaskChainUtil.log("Shouldn't execute due to null abort")).execute(() -> TaskChainUtil.log("finished runnable based test"));
        });
        factory.newSharedChain("TEST2").delay(60).sync(() -> TaskChainUtil.log("this should run at same time as 1st test")).delay(20).async(() -> TaskChainUtil.log("this should run at same time as 2nd test")).execute(finished -> TaskChainUtil.log("TEST2 finished: " + finished));
        factory.newChain().asyncFirst(() -> 42).asyncLast(i -> {
            throw new RuntimeException("Got " + i);
        }).execute(finished -> TaskChainUtil.log("Finished error chain: " + finished), (e, task) -> TaskChainUtil.logError("Got Exception on task " + task.getClass().getName() + ":" + e.getMessage()));
        factory.newChain().sync(() -> TaskChainUtil.log("THE FIRST!")).delay(200).async(() -> TaskChainUtil.log("This ran async - with no input or return")).asyncFirstCallback(next -> {
            TaskChainUtil.log("this also ran async, but will call next task in 3 seconds.");
            factory.getImplementation().scheduleTask(60, () -> next.accept(3));
        }).sync(input -> {
            TaskChainUtil.log("should of got 3: " + input);
            return 5 + input;
        }).storeAsData("Test1").syncLast(input2 -> TaskChainUtil.log("should be 8: " + input2)).delay(20).sync(() -> TaskChainUtil.log("Generic 1s later")).asyncFirst(() -> 3).delay(100).asyncLast(input1 -> TaskChainUtil.log("async last value 5s later: " + input1)).returnData("Test1").asyncLast(val -> TaskChainUtil.log("Should of got 8 back from data: " + val)).returnData("Test1").abortIf(8).sync(() -> TaskChainUtil.log("Shouldn't be called")).execute(finished -> TaskChainUtil.log("final test chain finished: " + finished));
    }
}

