/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.taskchain;

import co.aikar.taskchain.AsyncQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class TaskChainAsyncQueue
implements AsyncQueue {
    private final AtomicInteger threadId = new AtomicInteger();
    private final ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("TaskChainAsyncQueue Thread " + this.threadId.getAndIncrement());
        return thread;
    });

    TaskChainAsyncQueue() {
    }

    @Override
    public void postAsync(Runnable runnable) {
        this.executor.submit(runnable);
    }

    @Override
    public void shutdown(int timeout, TimeUnit unit) {
        try {
            this.executor.setRejectedExecutionHandler((r, executor1) -> r.run());
            this.executor.shutdown();
            this.executor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

