/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.taskchain;

import co.aikar.taskchain.AsyncQueue;
import co.aikar.taskchain.GameInterface;
import co.aikar.taskchain.TaskChainAsyncQueue;
import co.aikar.taskchain.TaskChainFactory;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.game.state.GameStoppingEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;

public class SpongeTaskChainFactory
extends TaskChainFactory {
    private SpongeTaskChainFactory(GameInterface impl) {
        super(impl);
    }

    public static TaskChainFactory create(PluginContainer pluginContainer) {
        return SpongeTaskChainFactory.create(pluginContainer.getInstance().orElse(null));
    }

    public static TaskChainFactory create(Object plugin) {
        return new SpongeTaskChainFactory(new SpongeGameInterface(plugin));
    }

    private static class SpongeGameInterface
    implements GameInterface {
        private final AsyncQueue asyncQueue;
        private final Object plugin;

        private SpongeGameInterface(Object plugin) {
            if (plugin == null || !Sponge.getPluginManager().fromInstance(plugin).isPresent()) {
                throw new IllegalArgumentException("Not a valid Sponge Plugin");
            }
            this.plugin = plugin;
            this.asyncQueue = new TaskChainAsyncQueue();
        }

        @Override
        public boolean isMainThread() {
            return Sponge.getServer().isMainThread();
        }

        @Override
        public AsyncQueue getAsyncQueue() {
            return this.asyncQueue;
        }

        @Override
        public void postToMain(Runnable run) {
            Task.builder().execute(run).submit(this.plugin);
        }

        @Override
        public void scheduleTask(int gameUnits, Runnable run) {
            Task.builder().delayTicks((long)gameUnits).execute(run).submit(this.plugin);
        }

        @Override
        public void registerShutdownHandler(TaskChainFactory factory) {
            Sponge.getEventManager().registerListener(this.plugin, GameStoppingEvent.class, event -> factory.shutdown(60, TimeUnit.SECONDS));
        }
    }
}

