/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.taskchain;

import co.aikar.taskchain.TaskChain;
import co.aikar.taskchain.TaskChainFactory;
import co.aikar.taskchain.TaskChainTasks;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class SharedTaskChain<R>
extends TaskChain<R> {
    private final String name;
    private final Map<String, Queue<SharedTaskChain>> sharedChains;
    private Queue<SharedTaskChain> queue;
    private boolean isReady;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SharedTaskChain(String name, TaskChainFactory factory) {
        super(factory);
        this.sharedChains = factory.getSharedChains();
        this.name = name;
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            this.queue = this.sharedChains.get(this.name);
            if (this.queue == null) {
                this.queue = new ConcurrentLinkedQueue<SharedTaskChain>();
                this.sharedChains.put(this.name, this.queue);
            }
            this.queue.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Consumer<Boolean> done, BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler) {
        this.setErrorHandler(errorHandler);
        this.setDoneCallback(finished -> {
            this.setDoneCallback(done);
            this.done((boolean)finished);
            this.processQueue();
        });
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            this.isReady = true;
        }
        if (this.queue.peek() == this) {
            this.execute0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        SharedTaskChain next;
        this.queue.poll();
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            next = this.queue.peek();
            if (next == null) {
                this.sharedChains.remove(this.name);
                return;
            }
            if (!next.isReady) {
                return;
            }
        }
        next.execute0();
    }
}

