/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.Locales;
import co.aikar.locales.MessageKey;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BukkitLocales
extends Locales {
    private final BukkitCommandManager manager;

    public BukkitLocales(BukkitCommandManager manager) {
        super(manager);
        this.manager = manager;
        this.addBundleClassLoader(this.manager.getPlugin().getClass().getClassLoader());
    }

    @Override
    public void loadLanguages() {
        super.loadLanguages();
        String pluginName = "acf-" + this.manager.plugin.getDescription().getName();
        this.addMessageBundles("acf-minecraft", pluginName, pluginName.toLowerCase(Locale.ENGLISH));
    }

    public boolean loadYamlLanguageFile(File file, Locale locale) throws IOException, InvalidConfigurationException {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.load(file);
        return this.loadLanguage((FileConfiguration)yamlConfiguration, locale);
    }

    public boolean loadYamlLanguageFile(String file, Locale locale) throws IOException, InvalidConfigurationException {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.load(new File(this.manager.plugin.getDataFolder(), file));
        return this.loadLanguage((FileConfiguration)yamlConfiguration, locale);
    }

    public boolean loadLanguage(FileConfiguration config, Locale locale) {
        boolean loaded = false;
        for (String parentKey : config.getKeys(false)) {
            ConfigurationSection inner = config.getConfigurationSection(parentKey);
            if (inner == null) continue;
            for (String key : inner.getKeys(false)) {
                String value = inner.getString(key);
                if (value == null || value.isEmpty()) continue;
                this.addMessage(locale, MessageKey.of(parentKey + "." + key), value);
                loaded = true;
            }
        }
        return loaded;
    }
}

