/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletionTextLookupException;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.CommandParameter;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.apachecommonslang.ApacheCommonsLangUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class CommandCompletions<C extends CommandCompletionContext> {
    private static final String DEFAULT_ENUM_ID = "@__defaultenum__";
    private final CommandManager manager;
    private Map<String, CommandCompletionHandler> completionMap = new HashMap<String, CommandCompletionHandler>();
    private Map<Class, String> defaultCompletions = new HashMap<Class, String>();

    public CommandCompletions(CommandManager manager) {
        this.manager = manager;
        this.registerStaticCompletion("empty", Collections.emptyList());
        this.registerStaticCompletion("nothing", Collections.emptyList());
        this.registerStaticCompletion("timeunits", Arrays.asList("minutes", "hours", "days", "weeks", "months", "years"));
        this.registerAsyncCompletion("range", c -> {
            int end;
            int start;
            String config = c.getConfig();
            if (config == null) {
                return Collections.emptyList();
            }
            String[] ranges = ACFPatterns.DASH.split(config);
            if (ranges.length != 2) {
                start = 0;
                end = ACFUtil.parseInt(ranges[0], 0);
            } else {
                start = ACFUtil.parseInt(ranges[0], 0);
                end = ACFUtil.parseInt(ranges[1], 0);
            }
            return IntStream.rangeClosed(start, end).mapToObj(Integer::toString).collect(Collectors.toList());
        });
    }

    public CommandCompletionHandler registerCompletion(String id, CommandCompletionHandler<C> handler) {
        return this.completionMap.put(CommandCompletions.prepareCompletionId(id), handler);
    }

    public CommandCompletionHandler registerAsyncCompletion(String id, AsyncCommandCompletionHandler<C> handler) {
        return this.completionMap.put(CommandCompletions.prepareCompletionId(id), handler);
    }

    public CommandCompletionHandler registerStaticCompletion(String id, String list) {
        return this.registerStaticCompletion(id, ACFPatterns.PIPE.split(list));
    }

    public CommandCompletionHandler registerStaticCompletion(String id, String[] completions) {
        return this.registerStaticCompletion(id, Arrays.asList(completions));
    }

    public CommandCompletionHandler registerStaticCompletion(String id, Supplier<Collection<String>> supplier) {
        return this.registerStaticCompletion(id, supplier.get());
    }

    public CommandCompletionHandler registerStaticCompletion(String id, Collection<String> completions) {
        return this.registerAsyncCompletion(id, x -> completions);
    }

    public void setDefaultCompletion(String id, Class ... classes) {
        CommandCompletionHandler completion = this.completionMap.get(id = CommandCompletions.prepareCompletionId(id));
        if (completion == null) {
            throw new IllegalStateException("Completion not registered for " + id);
        }
        for (Class clazz : classes) {
            this.defaultCompletions.put(clazz, id);
        }
    }

    @NotNull
    private static String prepareCompletionId(String id) {
        return (id.startsWith("@") ? "" : "@") + id.toLowerCase();
    }

    @NotNull
    List<String> of(RegisteredCommand cmd, CommandIssuer sender, String[] args, boolean isAsync) {
        String completion;
        String[] completions = ACFPatterns.SPACE.split(cmd.complete);
        int argIndex = args.length - 1;
        String input = args[argIndex];
        String string = completion = argIndex < completions.length ? completions[argIndex] : null;
        if (completion == null || "*".equals(completion)) {
            completion = this.findDefaultCompletion(cmd, args);
        }
        if (completion == null && completions.length > 0) {
            String last = completions[completions.length - 1];
            if (last.startsWith("repeat@")) {
                completion = last;
            } else if (argIndex >= completions.length && cmd.parameters[cmd.parameters.length - 1].consumesRest) {
                completion = last;
            }
        }
        if (completion == null) {
            return Collections.singletonList(input);
        }
        return this.getCompletionValues(cmd, sender, completion, args, isAsync);
    }

    String findDefaultCompletion(RegisteredCommand cmd, String[] args) {
        int i = 0;
        for (CommandParameter param : cmd.parameters) {
            if (!param.canConsumeInput() || ++i != args.length) continue;
            for (Class<?> type = param.getType(); type != null; type = type.getSuperclass()) {
                String completion = this.defaultCompletions.get(type);
                if (completion == null) continue;
                return completion;
            }
            if (!param.getType().isEnum()) break;
            CommandOperationContext ctx = CommandManager.getCurrentCommandOperationContext();
            ctx.enumCompletionValues = ACFUtil.enumNames(param.getType());
            return DEFAULT_ENUM_ID;
        }
        return null;
    }

    List<String> getCompletionValues(RegisteredCommand command, CommandIssuer sender, String completion, String[] args, boolean isAsync) {
        if (DEFAULT_ENUM_ID.equals(completion)) {
            CommandOperationContext ctx = CommandManager.getCurrentCommandOperationContext();
            return ctx.enumCompletionValues;
        }
        boolean repeat = completion.startsWith("repeat@");
        if (repeat) {
            completion = completion.substring(6);
        }
        completion = this.manager.getCommandReplacements().replace(completion);
        ArrayList<String> allCompletions = new ArrayList<String>();
        String input = args.length > 0 ? args[args.length - 1] : "";
        for (String value : ACFPatterns.PIPE.split(completion)) {
            String[] complete = ACFPatterns.COLONEQUALS.split(value, 2);
            CommandCompletionHandler handler = this.completionMap.get(complete[0].toLowerCase());
            if (handler != null) {
                if (isAsync && !(handler instanceof AsyncCommandCompletionHandler)) {
                    ACFUtil.sneaky(new SyncCompletionRequired());
                    return null;
                }
                String config = complete.length == 1 ? null : complete[1];
                CommandCompletionContext context = this.manager.createCompletionContext(command, sender, input, config, args);
                try {
                    Collection completions = handler.getCompletions(context);
                    if (!repeat && completions != null && command.parameters[command.parameters.length - 1].consumesRest && args.length > ACFPatterns.SPACE.split(command.complete).length) {
                        String start = String.join((CharSequence)" ", args);
                        completions = completions.stream().filter(s -> s != null && s.split(" ").length >= args.length).filter(s -> ApacheCommonsLangUtil.startsWithIgnoreCase(s, start)).map(s -> {
                            String[] completionArgs = s.split(" ");
                            return String.join((CharSequence)" ", Arrays.copyOfRange(completionArgs, args.length - 1, completionArgs.length));
                        }).collect(Collectors.toList());
                    }
                    if (completions != null) {
                        allCompletions.addAll(completions);
                        continue;
                    }
                }
                catch (CommandCompletionTextLookupException completions) {
                }
                catch (Exception e) {
                    command.handleException(sender, Arrays.asList(args), e);
                }
                return Collections.singletonList(input);
            }
            allCompletions.add(value);
        }
        return allCompletions;
    }

    public static class SyncCompletionRequired
    extends RuntimeException {
    }

    public static interface AsyncCommandCompletionHandler<C extends CommandCompletionContext>
    extends CommandCompletionHandler<C> {
    }

    public static interface CommandCompletionHandler<C extends CommandCompletionContext> {
        public Collection<String> getCompletions(C var1) throws InvalidCommandArgument;
    }
}

