/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFUtil;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.apachecommonslang.ApacheCommonsLangUtil;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface RootCommand {
    public void addChild(BaseCommand var1);

    public CommandManager getManager();

    public SetMultimap<String, RegisteredCommand> getSubCommands();

    public List<BaseCommand> getChildren();

    public String getCommandName();

    default public void addChildShared(List<BaseCommand> children, SetMultimap<String, RegisteredCommand> subCommands, BaseCommand command) {
        command.subCommands.entries().forEach(e -> {
            BaseCommand prevBase;
            String key = (String)e.getKey();
            RegisteredCommand registeredCommand = (RegisteredCommand)e.getValue();
            if (key.equals("__default") || key.equals("__catchunknown")) {
                return;
            }
            Set registered = subCommands.get((Object)key);
            if (!registered.isEmpty() && (prevBase = ((RegisteredCommand)registered.iterator().next()).scope) != registeredCommand.scope) {
                this.getManager().log(LogLevel.ERROR, "ACF Error: " + command.getName() + " registered subcommand " + key + " for root command " + this.getCommandName() + " - but it is already defined in " + prevBase.getName());
                this.getManager().log(LogLevel.ERROR, "2 subcommands of the same prefix may not be spread over 2 different classes. Ignoring this.");
                return;
            }
            subCommands.put((Object)key, (Object)registeredCommand);
        });
        children.add(command);
    }

    default public String getUniquePermission() {
        HashSet<String> permissions = new HashSet<String>();
        for (BaseCommand child : this.getChildren()) {
            for (RegisteredCommand value : child.subCommands.values()) {
                Set<String> requiredPermissions = value.getRequiredPermissions();
                if (requiredPermissions.isEmpty()) {
                    return null;
                }
                permissions.addAll(requiredPermissions);
            }
        }
        return permissions.size() == 1 ? (String)permissions.iterator().next() : null;
    }

    default public boolean hasAnyPermission(CommandIssuer issuer) {
        List<BaseCommand> children = this.getChildren();
        if (children.isEmpty()) {
            return true;
        }
        for (BaseCommand child : children) {
            if (!child.hasPermission(issuer)) continue;
            for (RegisteredCommand value : child.getRegisteredCommands()) {
                if (!value.hasPermission(issuer)) continue;
                return true;
            }
        }
        return false;
    }

    default public BaseCommand execute(CommandIssuer sender, String commandLabel, String[] args) {
        BaseCommand command = this.getBaseCommand(args);
        command.execute(sender, commandLabel, args);
        return command;
    }

    default public BaseCommand getBaseCommand(String[] args) {
        Set registeredCommands;
        SetMultimap<String, RegisteredCommand> subCommands = this.getSubCommands();
        for (int i = args.length; i >= 0; --i) {
            String checkSub = ApacheCommonsLangUtil.join((Object[])args, " ", 0, i).toLowerCase();
            registeredCommands = subCommands.get((Object)checkSub);
            if (registeredCommands.isEmpty()) continue;
            return ((RegisteredCommand)ACFUtil.getFirstElement(registeredCommands)).scope;
        }
        registeredCommands = subCommands.get((Object)"__default");
        if (!registeredCommands.isEmpty()) {
            RegisteredCommand command = (RegisteredCommand)ACFUtil.getFirstElement(registeredCommands);
            if (args.length == 0 || command.consumeInputResolvers > 0) {
                return command.scope;
            }
        }
        if (!(registeredCommands = subCommands.get((Object)"__catchunknown")).isEmpty()) {
            return ((RegisteredCommand)ACFUtil.getFirstElement(registeredCommands)).scope;
        }
        return this.getDefCommand();
    }

    default public List<String> getTabCompletions(CommandIssuer sender, String alias, String[] args) {
        return this.getTabCompletions(sender, alias, args, false);
    }

    default public List<String> getTabCompletions(CommandIssuer sender, String alias, String[] args, boolean commandsOnly) {
        return this.getTabCompletions(sender, alias, args, commandsOnly, false);
    }

    default public List<String> getTabCompletions(CommandIssuer sender, String alias, String[] args, boolean commandsOnly, boolean isAsync) {
        HashSet completions = new HashSet();
        this.getChildren().forEach(child -> {
            if (!commandsOnly) {
                completions.addAll(child.tabComplete(sender, alias, args, isAsync));
            }
            completions.addAll(child.getCommandsForCompletion(sender, args));
        });
        return new ArrayList<String>(completions);
    }

    default public RegisteredCommand getDefaultRegisteredCommand() {
        BaseCommand defCommand = this.getDefCommand();
        if (defCommand != null) {
            return defCommand.getDefaultRegisteredCommand();
        }
        return null;
    }

    default public BaseCommand getDefCommand() {
        return null;
    }

    default public String getDescription() {
        RegisteredCommand cmd = this.getDefaultRegisteredCommand();
        if (cmd != null) {
            return cmd.getHelpText();
        }
        BaseCommand defCommand = this.getDefCommand();
        if (defCommand != null && defCommand.description != null) {
            return defCommand.description;
        }
        return "";
    }

    default public String getUsage() {
        RegisteredCommand cmd = this.getDefaultRegisteredCommand();
        if (cmd != null) {
            return cmd.syntaxText != null ? cmd.syntaxText : "";
        }
        return "";
    }
}

