/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.ConditionContext;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.LogLevel;
import co.aikar.commands.RegisteredCommand;
import co.aikar.util.Table;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommandConditions<I extends CommandIssuer, CEC extends CommandExecutionContext<CEC, I>, CC extends ConditionContext<I>> {
    private CommandManager manager;
    private Map<String, Condition<I>> conditions = Maps.newHashMap();
    private Table<Class<?>, String, ParameterCondition<?, ?, ?>> paramConditions = new Table();

    CommandConditions(CommandManager manager) {
        this.manager = manager;
    }

    public Condition<I> addCondition(@NotNull String id, @NotNull Condition<I> handler) {
        return this.conditions.put(id.toLowerCase(), handler);
    }

    public <P> ParameterCondition addCondition(Class<P> clazz, @NotNull String id, @NotNull ParameterCondition<P, CEC, I> handler) {
        return this.paramConditions.put(clazz, id.toLowerCase(), handler);
    }

    void validateConditions(CommandOperationContext context) throws InvalidCommandArgument {
        RegisteredCommand cmd = context.getRegisteredCommand();
        this.validateConditions(cmd.conditions, context);
        this.validateConditions(cmd.scope, context);
    }

    private void validateConditions(BaseCommand scope, CommandOperationContext operationContext) throws InvalidCommandArgument {
        this.validateConditions(scope.conditions, operationContext);
        if (scope.parentCommand != null) {
            this.validateConditions(scope.parentCommand, operationContext);
        }
    }

    private void validateConditions(String conditions, CommandOperationContext context) throws InvalidCommandArgument {
        if (conditions == null) {
            return;
        }
        conditions = this.manager.getCommandReplacements().replace(conditions);
        Object issuer = context.getCommandIssuer();
        for (String cond : ACFPatterns.PIPE.split(conditions)) {
            String[] split = ACFPatterns.COLON.split(cond, 2);
            String id = split[0].toLowerCase();
            Condition<I> condition = this.conditions.get(id);
            if (condition == null) {
                RegisteredCommand cmd = context.getRegisteredCommand();
                this.manager.log(LogLevel.ERROR, "Could not find command condition " + id + " for " + cmd.method.getName());
                continue;
            }
            String config = split.length == 2 ? split[1] : null;
            ConditionContext conditionContext = this.manager.createConditionContext((CommandIssuer)issuer, config);
            condition.validateCondition(conditionContext);
        }
    }

    void validateConditions(CEC execContext, Object value) throws InvalidCommandArgument {
        String conditions = ((CommandExecutionContext)execContext).getCommandParameter().getConditions();
        if (conditions == null) {
            return;
        }
        conditions = this.manager.getCommandReplacements().replace(conditions);
        Object issuer = ((CommandExecutionContext)execContext).getIssuer();
        for (String cond : ACFPatterns.PIPE.split(conditions)) {
            ParameterCondition<?, ?, ?> condition;
            String[] split = ACFPatterns.COLON.split(cond, 2);
            Class<?> cls = ((CommandExecutionContext)execContext).getParam().getType();
            String id = split[0].toLowerCase();
            while ((condition = this.paramConditions.get(cls, id)) == null && cls.getSuperclass() != null && cls.getSuperclass() != Object.class && (cls = cls.getSuperclass()) != null) {
            }
            if (condition == null) {
                RegisteredCommand cmd = ((CommandExecutionContext)execContext).getCmd();
                this.manager.log(LogLevel.ERROR, "Could not find command condition " + id + " for " + cmd.method.getName() + "::" + ((CommandExecutionContext)execContext).getParam().getName());
                continue;
            }
            String config = split.length == 2 ? split[1] : null;
            ConditionContext conditionContext = this.manager.createConditionContext((CommandIssuer)issuer, config);
            condition.validateCondition(conditionContext, execContext, value);
        }
    }

    public static interface ParameterCondition<P, CEC extends CommandExecutionContext, I extends CommandIssuer> {
        public void validateCondition(ConditionContext<I> var1, CEC var2, P var3) throws InvalidCommandArgument;
    }

    public static interface Condition<I extends CommandIssuer> {
        public void validateCondition(ConditionContext<I> var1) throws InvalidCommandArgument;
    }
}

