/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.CommandHelp;
import co.aikar.commands.CommandParameter;
import co.aikar.commands.RegisteredCommand;

public class HelpEntry {
    private final CommandHelp commandHelp;
    private final RegisteredCommand command;
    private int searchScore = 1;

    HelpEntry(CommandHelp commandHelp, RegisteredCommand command) {
        this.commandHelp = commandHelp;
        this.command = command;
    }

    RegisteredCommand getRegisteredCommand() {
        return this.command;
    }

    public String getCommand() {
        return this.commandHelp.commandPrefix + this.command.command;
    }

    public String getParameterSyntax() {
        return this.command.syntaxText != null ? this.command.syntaxText : "";
    }

    public String getDescription() {
        return this.command.helpText != null ? this.command.helpText : "";
    }

    public void setSearchScore(int searchScore) {
        this.searchScore = searchScore;
    }

    public boolean shouldShow() {
        return this.searchScore > 0;
    }

    public int getSearchScore() {
        return this.searchScore;
    }

    public String getSearchTags() {
        return this.command.helpSearchTags;
    }

    public CommandParameter[] getParameters() {
        return this.command.parameters;
    }
}

