/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.Annotations;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandHelp;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.CommandParameter;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MessageType;
import co.aikar.commands.ShowCommandHelp;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Conditions;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.HelpSearchTags;
import co.aikar.commands.annotation.Syntax;
import co.aikar.commands.contexts.ContextResolver;
import co.aikar.locales.MessageKeyProvider;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class RegisteredCommand<CEC extends CommandExecutionContext<CEC, ? extends CommandIssuer>> {
    final BaseCommand scope;
    final Method method;
    final CommandParameter<CEC>[] parameters;
    final CommandManager manager;
    final List<String> registeredSubcommands = new ArrayList<String>();
    String command;
    String prefSubCommand;
    String syntaxText;
    String helpText;
    String permission;
    String complete;
    String conditions;
    public String helpSearchTags;
    final int requiredResolvers;
    final int consumeInputResolvers;
    final int doesNotConsumeInputResolvers;
    final int optionalResolvers;

    RegisteredCommand(BaseCommand scope, String command, Method method, String prefSubCommand) {
        this.scope = scope;
        this.manager = this.scope.manager;
        Annotations annotations = this.manager.getAnnotations();
        if ("__catchunknown".equals(prefSubCommand) || "__default".equals(prefSubCommand)) {
            prefSubCommand = "";
        }
        this.command = command + (!annotations.hasAnnotation(method, CommandAlias.class, false) && !prefSubCommand.isEmpty() ? prefSubCommand : "");
        this.method = method;
        this.prefSubCommand = prefSubCommand;
        this.permission = annotations.getAnnotationValue(method, CommandPermission.class, Annotations.REPLACEMENTS | Annotations.NO_EMPTY);
        this.complete = annotations.getAnnotationValue(method, CommandCompletion.class);
        this.helpText = annotations.getAnnotationValue(method, Description.class, Annotations.REPLACEMENTS | Annotations.DEFAULT_EMPTY);
        this.conditions = annotations.getAnnotationValue(method, Conditions.class, Annotations.REPLACEMENTS | Annotations.NO_EMPTY);
        this.helpSearchTags = annotations.getAnnotationValue(method, HelpSearchTags.class, Annotations.REPLACEMENTS | Annotations.NO_EMPTY);
        Parameter[] parameters = method.getParameters();
        this.parameters = new CommandParameter[parameters.length];
        int requiredResolvers = 0;
        int consumeInputResolvers = 0;
        int doesNotConsumeInputResolvers = 0;
        int optionalResolvers = 0;
        StringBuilder syntaxBuilder = new StringBuilder(64);
        for (int i = 0; i < parameters.length; ++i) {
            this.parameters[i] = new CommandParameter(this, parameters[i], i);
            CommandParameter parameter = this.parameters[i];
            if (!parameter.isCommandIssuer()) {
                if (!parameter.requiresInput()) {
                    ++optionalResolvers;
                } else {
                    ++requiredResolvers;
                }
                if (parameter.canConsumeInput()) {
                    ++consumeInputResolvers;
                } else {
                    ++doesNotConsumeInputResolvers;
                }
            }
            if (parameter.getSyntax() == null) continue;
            if (syntaxBuilder.length() > 0) {
                syntaxBuilder.append(' ');
            }
            syntaxBuilder.append(parameter.getSyntax());
        }
        String syntaxText = syntaxBuilder.toString().trim();
        String syntaxStr = annotations.getAnnotationValue(method, Syntax.class);
        this.syntaxText = syntaxStr != null ? ACFUtil.replace(syntaxStr, "@syntax", syntaxText) : syntaxText;
        this.requiredResolvers = requiredResolvers;
        this.consumeInputResolvers = consumeInputResolvers;
        this.doesNotConsumeInputResolvers = doesNotConsumeInputResolvers;
        this.optionalResolvers = optionalResolvers;
    }

    void invoke(CommandIssuer sender, List<String> args, CommandOperationContext context) {
        if (!this.scope.canExecute(sender, this)) {
            return;
        }
        this.preCommand();
        try {
            this.manager.conditions.validateConditions(context);
            Map<String, Object> passedArgs = this.resolveContexts(sender, args);
            if (passedArgs == null) {
                return;
            }
            this.method.invoke((Object)this.scope, passedArgs.values().toArray());
        }
        catch (Exception e) {
            this.handleException(sender, args, e);
        }
        this.postCommand();
    }

    public void preCommand() {
    }

    public void postCommand() {
    }

    void handleException(CommandIssuer sender, List<String> args, Exception e) {
        if (e instanceof InvocationTargetException && e.getCause() instanceof InvalidCommandArgument) {
            e = (Exception)e.getCause();
        }
        if (e instanceof ShowCommandHelp) {
            ShowCommandHelp showHelp = (ShowCommandHelp)e;
            CommandHelp commandHelp = this.manager.generateCommandHelp();
            if (showHelp.search) {
                commandHelp.setSearch(showHelp.searchArgs == null ? args : showHelp.searchArgs);
            }
            commandHelp.showHelp(sender);
        } else if (e instanceof InvalidCommandArgument) {
            InvalidCommandArgument invalidCommandArg = (InvalidCommandArgument)e;
            if (invalidCommandArg.key != null) {
                sender.sendMessage(MessageType.ERROR, invalidCommandArg.key, invalidCommandArg.replacements);
            } else if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                sender.sendMessage(MessageType.ERROR, MessageKeys.ERROR_PREFIX, "{message}", e.getMessage());
            }
            if (invalidCommandArg.showSyntax) {
                this.scope.showSyntax(sender, this);
            }
        } else {
            try {
                if (!this.manager.handleUncaughtException(this.scope, this, sender, args, e)) {
                    sender.sendMessage(MessageType.ERROR, MessageKeys.ERROR_PERFORMING_COMMAND, new String[0]);
                }
                this.manager.log(LogLevel.ERROR, "Exception in command: " + this.command + " " + ACFUtil.join(args), e);
            }
            catch (Exception e2) {
                this.manager.log(LogLevel.ERROR, "Exception in handleException for command: " + this.command + " " + ACFUtil.join(args), e);
                this.manager.log(LogLevel.ERROR, "Exception triggered by exception handler:", e2);
            }
        }
    }

    @Nullable
    Map<String, Object> resolveContexts(CommandIssuer sender, List<String> args) throws InvalidCommandArgument {
        return this.resolveContexts(sender, args, this.parameters.length);
    }

    @Nullable
    Map<String, Object> resolveContexts(CommandIssuer sender, List<String> args, int argLimit) throws InvalidCommandArgument {
        args = Lists.newArrayList(args);
        String[] origArgs = args.toArray(new String[args.size()]);
        LinkedHashMap passedArgs = Maps.newLinkedHashMap();
        int remainingRequired = this.requiredResolvers;
        CommandOperationContext opContext = CommandManager.getCurrentCommandOperationContext();
        for (int i = 0; i < this.parameters.length && i < argLimit; ++i) {
            boolean isLast = i == this.parameters.length - 1;
            boolean allowOptional = remainingRequired == 0;
            CommandParameter<CEC> parameter = this.parameters[i];
            if (parameter.isCommandIssuer()) {
                ++argLimit;
            }
            String parameterName = parameter.getName();
            Class<?> type = parameter.getType();
            ContextResolver<?, CEC> resolver = parameter.getResolver();
            CommandExecutionContext context = this.manager.createCommandContext(this, parameter, sender, args, i, passedArgs);
            boolean requiresInput = parameter.requiresInput();
            if (requiresInput && remainingRequired > 0) {
                --remainingRequired;
            }
            if (args.isEmpty() && (!isLast || type != String[].class)) {
                if (allowOptional && parameter.getDefaultValue() != null) {
                    args.add(parameter.getDefaultValue());
                } else {
                    if (allowOptional && parameter.isOptional()) {
                        Object value;
                        Object v = value = parameter.isOptionalResolver() ? (Object)resolver.getContext(context) : null;
                        if (value == null && parameter.getClass().isPrimitive()) {
                            throw new IllegalStateException("Parameter " + parameter.getName() + " is primitive and does not support Optional.");
                        }
                        this.manager.conditions.validateConditions(context, value);
                        passedArgs.put(parameterName, value);
                        continue;
                    }
                    if (requiresInput) {
                        this.scope.showSyntax(sender, this);
                        return null;
                    }
                }
            }
            if (parameter.getValues() != null) {
                String arg = !args.isEmpty() ? (String)args.get(0) : "";
                HashSet possible = Sets.newHashSet();
                CommandCompletions<?> commandCompletions = this.manager.getCommandCompletions();
                for (String s : parameter.getValues()) {
                    List<String> check = commandCompletions.getCompletionValues(this, sender, s, origArgs, opContext.isAsync());
                    if (!check.isEmpty()) {
                        possible.addAll(check.stream().map(String::toLowerCase).collect(Collectors.toList()));
                        continue;
                    }
                    possible.add(s.toLowerCase());
                }
                if (!possible.contains(arg.toLowerCase())) {
                    throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", ACFUtil.join(possible, ", "));
                }
            }
            Object paramValue = resolver.getContext(context);
            this.manager.conditions.validateConditions(context, paramValue);
            passedArgs.put(parameterName, paramValue);
        }
        return passedArgs;
    }

    boolean hasPermission(CommandIssuer issuer) {
        return (this.permission == null || this.permission.isEmpty() || this.scope.manager.hasPermission(issuer, this.permission)) && this.scope.hasPermission(issuer);
    }

    @Deprecated
    public String getPermission() {
        if (this.permission == null || this.permission.isEmpty()) {
            return null;
        }
        return ACFPatterns.COMMA.split(this.permission)[0];
    }

    public Set<String> getRequiredPermissions() {
        if (this.permission == null || this.permission.isEmpty()) {
            return ImmutableSet.of();
        }
        return Sets.newHashSet((Object[])ACFPatterns.COMMA.split(this.permission));
    }

    public boolean requiresPermission(String permission) {
        return this.getRequiredPermissions().contains(permission) || this.scope.requiresPermission(permission);
    }

    public String getPrefSubCommand() {
        return this.prefSubCommand;
    }

    public String getSyntaxText() {
        return this.syntaxText;
    }

    public String getCommand() {
        return this.command;
    }

    public void addSubcommand(String cmd) {
        this.registeredSubcommands.add(cmd);
    }

    public void addSubcommands(Collection<String> cmd) {
        this.registeredSubcommands.addAll(cmd);
    }
}

