/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletionTextLookupException;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.RegisteredCommand;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class CommandCompletions<C extends CommandCompletionContext> {
    private final CommandManager manager;
    private Map<String, CommandCompletionHandler> completionMap = new HashMap<String, CommandCompletionHandler>();

    public CommandCompletions(CommandManager manager) {
        this.manager = manager;
        this.registerAsyncCompletion("nothing", c -> ImmutableList.of());
        this.registerAsyncCompletion("range", c -> {
            int end;
            int start;
            String config = c.getConfig();
            if (config == null) {
                return ImmutableList.of();
            }
            String[] ranges = ACFPatterns.DASH.split(config);
            if (ranges.length != 2) {
                start = 0;
                end = ACFUtil.parseInt(ranges[0], 0);
            } else {
                start = ACFUtil.parseInt(ranges[0], 0);
                end = ACFUtil.parseInt(ranges[1], 0);
            }
            return IntStream.rangeClosed(start, end).mapToObj(Integer::toString).collect(Collectors.toList());
        });
        this.registerAsyncCompletion("timeunits", c -> ImmutableList.of((Object)"minutes", (Object)"hours", (Object)"days", (Object)"weeks", (Object)"months", (Object)"years"));
    }

    public CommandCompletionHandler registerCompletion(String id, CommandCompletionHandler<C> handler) {
        return this.completionMap.put("@" + id.toLowerCase(), handler);
    }

    public CommandCompletionHandler registerAsyncCompletion(String id, AsyncCommandCompletionHandler<C> handler) {
        return this.completionMap.put("@" + id.toLowerCase(), handler);
    }

    @NotNull
    List<String> of(RegisteredCommand cmd, CommandIssuer sender, String[] args, boolean isAsync) {
        String completion;
        String[] completions = ACFPatterns.SPACE.split(cmd.complete);
        int argIndex = args.length - 1;
        String input = args[argIndex];
        String string = completion = argIndex < completions.length ? completions[argIndex] : null;
        if (completion == null && completions.length > 0) {
            completion = completions[completions.length - 1];
        }
        if (completion == null) {
            return ImmutableList.of((Object)input);
        }
        return this.getCompletionValues(cmd, sender, completion, args, isAsync);
    }

    List<String> getCompletionValues(RegisteredCommand command, CommandIssuer sender, String completion, String[] args, boolean isAsync) {
        completion = this.manager.getCommandReplacements().replace(completion);
        ArrayList allCompletions = Lists.newArrayList();
        String input = args.length > 0 ? args[args.length - 1] : "";
        for (String value : ACFPatterns.PIPE.split(completion)) {
            String[] complete = ACFPatterns.COLONEQUALS.split(value, 2);
            CommandCompletionHandler handler = this.completionMap.get(complete[0].toLowerCase());
            if (handler != null) {
                if (isAsync && !(handler instanceof AsyncCommandCompletionHandler)) {
                    ACFUtil.sneaky(new SyncCompletionRequired());
                    return null;
                }
                String config = complete.length == 1 ? null : complete[1];
                CommandCompletionContext context = this.manager.createCompletionContext(command, sender, input, config, args);
                try {
                    Collection<String> completions = handler.getCompletions(context);
                    if (completions != null) {
                        allCompletions.addAll(completions);
                        continue;
                    }
                }
                catch (CommandCompletionTextLookupException completions) {
                }
                catch (Exception e) {
                    command.handleException(sender, Lists.newArrayList((Object[])args), e);
                }
                return ImmutableList.of((Object)input);
            }
            allCompletions.add(value);
        }
        return allCompletions;
    }

    public static class SyncCompletionRequired
    extends Exception {
    }

    public static interface AsyncCommandCompletionHandler<C extends CommandCompletionContext>
    extends CommandCompletionHandler<C> {
    }

    public static interface CommandCompletionHandler<C extends CommandCompletionContext> {
        public Collection<String> getCompletions(C var1) throws InvalidCommandArgument;
    }
}

