/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandHelp;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandParameter;
import co.aikar.commands.HelpEntry;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MessageType;
import org.jetbrains.annotations.NotNull;

public class CommandHelpFormatter {
    private final CommandManager manager;

    public CommandHelpFormatter(CommandManager manager) {
        this.manager = manager;
    }

    public void printHelpHeader(CommandHelp help, CommandIssuer issuer) {
        issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_HEADER, this.getHeaderFooterFormatReplacements(help));
    }

    public void printHelpEntry(CommandHelp help, CommandIssuer issuer, HelpEntry entry) {
        String formatted = this.manager.formatMessage(issuer, MessageType.HELP, MessageKeys.HELP_FORMAT, this.getEntryFormatReplacements(help, entry));
        for (String msg : ACFPatterns.NEWLINE.split(formatted)) {
            issuer.sendMessageInternal(ACFUtil.rtrim(msg));
        }
    }

    public void printHelpFooter(CommandHelp help, CommandIssuer issuer) {
        if (help.isLastPage()) {
            return;
        }
        issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_PAGE_INFORMATION, this.getHeaderFooterFormatReplacements(help));
    }

    public void printSearchHeader(CommandHelp help, CommandIssuer issuer) {
        issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_SEARCH_HEADER, this.getHeaderFooterFormatReplacements(help));
    }

    public void printSearchEntry(CommandHelp help, CommandIssuer issuer, HelpEntry page) {
        String formatted = this.manager.formatMessage(issuer, MessageType.HELP, MessageKeys.HELP_FORMAT, this.getEntryFormatReplacements(help, page));
        for (String msg : ACFPatterns.NEWLINE.split(formatted)) {
            issuer.sendMessageInternal(ACFUtil.rtrim(msg));
        }
    }

    public void printSearchFooter(CommandHelp help, CommandIssuer issuer) {
        if (help.isLastPage()) {
            return;
        }
        issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_PAGE_INFORMATION, this.getHeaderFooterFormatReplacements(help));
    }

    public void printDetailedHelpHeader(CommandHelp help, CommandIssuer issuer, String command, HelpEntry entry) {
        issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_DETAILED_HEADER, "{command}", entry.getCommand(), "{command}", command);
    }

    public void printDetailedParameter(CommandHelp help, CommandIssuer issuer, HelpEntry entry, CommandParameter param) {
        String formattedMsg = this.manager.formatMessage(issuer, MessageType.HELP, MessageKeys.HELP_DETAILED_PARAMETER_FORMAT, this.getParameterFormatReplacements(help, param.getName(), param.getDescription(), entry));
        for (String msg : ACFPatterns.NEWLINE.split(formattedMsg)) {
            issuer.sendMessageInternal(ACFUtil.rtrim(msg));
        }
    }

    public void printDetailedHelpFooter(CommandHelp help, CommandIssuer issuer, HelpEntry entry) {
    }

    public String[] getHeaderFooterFormatReplacements(CommandHelp help) {
        return new String[]{"{search}", help.search != null ? String.join((CharSequence)" ", help.search) : "", "{command}", help.getCommandName(), "{rootcommand}", help.getCommandName(), "{page}", "" + help.getPage(), "{totalpages}", "" + help.getTotalPages(), "{results}", "" + help.getTotalResults()};
    }

    public String[] getEntryFormatReplacements(CommandHelp help, HelpEntry e) {
        return new String[]{"{command}", e.getCommand(), "{rootcommand}", help.getCommandName(), "{parameters}", e.getParameterSyntax(), "{separator}", e.getDescription().isEmpty() ? "" : "-", "{description}", e.getDescription()};
    }

    @NotNull
    public String[] getParameterFormatReplacements(CommandHelp help, String name, String description, HelpEntry page) {
        return new String[]{"{name}", name, "{description}", description, "{command}", page.getCommand(), "{rootcommand}", help.getCommandName()};
    }
}

