/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.LogLevel;
import co.aikar.commands.PaperCommandManager;
import co.aikar.commands.RootCommand;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;

class PaperAsyncTabCompleteHandler
implements Listener {
    private final PaperCommandManager manager;

    PaperAsyncTabCompleteHandler(PaperCommandManager manager) {
        this.manager = manager;
        manager.log(LogLevel.INFO, "Enabled Asynchronous Tab Completion Support!");
    }

    @EventHandler(ignoreCancelled=true)
    public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
        String buffer = event.getBuffer();
        if (!event.isCommand() && !buffer.startsWith("/") || buffer.indexOf(32) == -1) {
            return;
        }
        try {
            String[] stringArray;
            String[] args = ACFPatterns.SPACE.split(buffer, -1);
            String commandLabel = args[0];
            if (commandLabel.startsWith("/")) {
                commandLabel = commandLabel.substring(1);
            }
            if (args.length > 1) {
                stringArray = Arrays.copyOfRange(args, 1, args.length);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            args = stringArray;
            BaseCommand cmd = this.manager.getBaseCommand(commandLabel, args);
            if (cmd == null) {
                return;
            }
            BukkitCommandIssuer issuer = this.manager.getCommandIssuer(event.getSender());
            List<String> results = cmd.tabComplete(issuer, commandLabel, args, true);
            if (event.getCompletions() instanceof ImmutableList) {
                event.setCompletions(new ArrayList(event.getCompletions()));
            }
            event.getCompletions().addAll(results);
            event.setHandled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTabComplete(TabCompleteEvent event) {
        RootCommand rootCommand;
        String buffer = event.getBuffer();
        if (!event.isCommand() && !buffer.startsWith("/")) {
            return;
        }
        String[] args = ACFPatterns.SPACE.split(buffer, -1);
        String commandLabel = args[0];
        if (commandLabel.startsWith("/")) {
            commandLabel = commandLabel.substring(1);
        }
        if ((rootCommand = this.manager.getRootCommand(commandLabel)) != null) {
            String[] stringArray;
            if (args.length > 1) {
                stringArray = Arrays.copyOfRange(args, 1, args.length);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            args = stringArray;
            BukkitCommandIssuer issuer = this.manager.getCommandIssuer(event.getSender());
            if (event.getCompletions() instanceof ImmutableList) {
                event.setCompletions(new ArrayList(event.getCompletions()));
            }
            event.getCompletions().addAll(rootCommand.getTabCompletions(issuer, commandLabel, args, true));
        }
    }
}

