/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.Annotations;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.InvalidCommandContextException;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.annotation.Conditions;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Flags;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.annotation.Syntax;
import co.aikar.commands.annotation.Values;
import co.aikar.commands.contexts.ContextResolver;
import co.aikar.commands.contexts.IssuerAwareContextResolver;
import co.aikar.commands.contexts.IssuerOnlyContextResolver;
import co.aikar.commands.contexts.OptionalContextResolver;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.Map;

public class CommandParameter<CEC extends CommandExecutionContext<CEC, ? extends CommandIssuer>> {
    private final Parameter parameter;
    private final Class<?> type;
    private final String name;
    private final CommandManager manager;
    private final int paramIndex;
    private ContextResolver<?, CEC> resolver;
    private boolean optional;
    private String description;
    private String defaultValue;
    private String syntax;
    private String conditions;
    private boolean requiresInput;
    private boolean commandIssuer;
    private String[] values;
    private Map<String, String> flags;
    private boolean canConsumeInput;
    private boolean optionalResolver;

    public CommandParameter(RegisteredCommand<CEC> command, Parameter param, int paramIndex) {
        this.parameter = param;
        this.type = param.getType();
        this.name = param.getName();
        this.manager = command.manager;
        this.paramIndex = paramIndex;
        Annotations annotations = this.manager.getAnnotations();
        this.defaultValue = annotations.getAnnotationValue(param, Default.class, Annotations.REPLACEMENTS | (this.type != String.class ? Annotations.NO_EMPTY : 0));
        this.description = annotations.getAnnotationValue(param, Description.class, Annotations.REPLACEMENTS | Annotations.DEFAULT_EMPTY);
        this.conditions = annotations.getAnnotationValue(param, Conditions.class, Annotations.REPLACEMENTS | Annotations.NO_EMPTY);
        this.resolver = this.manager.getCommandContexts().getResolver(this.type);
        if (this.resolver == null) {
            ACFUtil.sneaky(new InvalidCommandContextException("Parameter " + this.type.getSimpleName() + " of " + command + " has no applicable context resolver"));
        }
        this.optional = annotations.hasAnnotation(param, Optional.class) || this.defaultValue != null;
        this.optionalResolver = this.isOptionalResolver(this.resolver);
        this.requiresInput = !this.optional && !this.optionalResolver;
        this.commandIssuer = this.manager.isCommandIssuer(this.type);
        this.canConsumeInput = !(this.resolver instanceof IssuerOnlyContextResolver);
        this.values = annotations.getAnnotationValues((AnnotatedElement)param, Values.class, Annotations.REPLACEMENTS | Annotations.NO_EMPTY);
        this.syntax = null;
        if (!this.commandIssuer) {
            this.syntax = annotations.getAnnotationValue(param, Syntax.class);
            if (this.syntax == null) {
                if (!this.requiresInput && this.canConsumeInput) {
                    this.syntax = "[" + this.name + "]";
                } else if (this.requiresInput) {
                    this.syntax = "<" + this.name + ">";
                }
            }
        }
        this.flags = Maps.newHashMap();
        String flags = annotations.getAnnotationValue(param, Flags.class, Annotations.REPLACEMENTS | Annotations.NO_EMPTY);
        if (flags != null) {
            this.parseFlags(flags);
        }
        this.inheritContextFlags(command.scope);
    }

    private void inheritContextFlags(BaseCommand scope) {
        if (!scope.contextFlags.isEmpty()) {
            Class<?> pCls = this.type;
            do {
                this.parseFlags(scope.contextFlags.get(pCls));
            } while ((pCls = pCls.getSuperclass()) != null);
        }
        if (scope.parentCommand != null) {
            this.inheritContextFlags(scope.parentCommand);
        }
    }

    private void parseFlags(String flags) {
        if (flags != null) {
            for (String s : ACFPatterns.COMMA.split(this.manager.getCommandReplacements().replace(flags))) {
                String[] v = ACFPatterns.EQUALS.split(s, 2);
                if (this.flags.containsKey(v[0])) continue;
                this.flags.put(v[0], v.length > 1 ? v[1] : null);
            }
        }
    }

    private boolean isOptionalResolver(ContextResolver<?, CEC> resolver) {
        return resolver instanceof IssuerAwareContextResolver || resolver instanceof IssuerOnlyContextResolver || resolver instanceof OptionalContextResolver;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public CommandManager getManager() {
        return this.manager;
    }

    public int getParamIndex() {
        return this.paramIndex;
    }

    public ContextResolver<?, CEC> getResolver() {
        return this.resolver;
    }

    public void setResolver(ContextResolver<?, CEC> resolver) {
        this.resolver = resolver;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isCommandIssuer() {
        return this.commandIssuer;
    }

    public void setCommandIssuer(boolean commandIssuer) {
        this.commandIssuer = commandIssuer;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<String, String> flags) {
        this.flags = flags;
    }

    public boolean canConsumeInput() {
        return this.canConsumeInput;
    }

    public void setCanConsumeInput(boolean canConsumeInput) {
        this.canConsumeInput = canConsumeInput;
    }

    public void setOptionalResolver(boolean optionalResolver) {
        this.optionalResolver = optionalResolver;
    }

    public boolean isOptionalResolver() {
        return this.optionalResolver;
    }

    public boolean requiresInput() {
        return this.requiresInput;
    }

    public void setRequiresInput(boolean requiresInput) {
        this.requiresInput = requiresInput;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public String getConditions() {
        return this.conditions;
    }

    public void setConditions(String conditions) {
        this.conditions = conditions;
    }
}

