/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandHelp;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.InvalidCommandContextException;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MessageType;
import co.aikar.commands.ShowCommandHelp;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.annotation.Syntax;
import co.aikar.commands.annotation.Values;
import co.aikar.commands.contexts.ContextResolver;
import co.aikar.commands.contexts.IssuerAwareContextResolver;
import co.aikar.commands.contexts.IssuerOnlyContextResolver;
import co.aikar.commands.contexts.OptionalContextResolver;
import co.aikar.locales.MessageKeyProvider;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class RegisteredCommand<CEC extends CommandExecutionContext<CEC, ? extends CommandIssuer>> {
    final BaseCommand scope;
    final String command;
    final Method method;
    final String prefSubCommand;
    final Parameter[] parameters;
    final ContextResolver<?, CEC>[] resolvers;
    final String syntaxText;
    final String helpText;
    private final String permission;
    final String complete;
    final int requiredResolvers;
    final int optionalResolvers;
    final List<String> registeredSubcommands = new ArrayList<String>();
    private final CommandManager manager;

    RegisteredCommand(BaseCommand scope, String command, Method method, String prefSubCommand) {
        this.scope = scope;
        this.manager = this.scope.manager;
        if ("__catchunknown".equals(prefSubCommand) || "__default".equals(prefSubCommand)) {
            prefSubCommand = "";
        }
        this.command = command + (method.getAnnotation(CommandAlias.class) == null && !prefSubCommand.isEmpty() ? prefSubCommand : "");
        this.method = method;
        this.prefSubCommand = prefSubCommand;
        CommandPermission permissionAnno = method.getAnnotation(CommandPermission.class);
        this.permission = permissionAnno != null ? scope.manager.getCommandReplacements().replace(permissionAnno.value()) : null;
        CommandCompletion completionAnno = method.getAnnotation(CommandCompletion.class);
        this.complete = completionAnno != null ? scope.manager.getCommandReplacements().replace(completionAnno.value()) : null;
        this.parameters = method.getParameters();
        Description descriptionAnno = method.getAnnotation(Description.class);
        this.helpText = descriptionAnno != null ? descriptionAnno.value() : "";
        this.resolvers = new ContextResolver[this.parameters.length];
        Syntax syntaxStr = method.getAnnotation(Syntax.class);
        CommandContexts<?> commandContexts = this.manager.getCommandContexts();
        int requiredResolvers = 0;
        int optionalResolvers = 0;
        StringBuilder syntaxB = new StringBuilder(64);
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter parameter = this.parameters[i];
            Class<?> type = parameter.getType();
            ContextResolver<?, ?> resolver = commandContexts.getResolver(type);
            if (resolver != null) {
                this.resolvers[i] = resolver;
                if (scope.manager.isCommandIssuer(type)) continue;
                String name = parameter.getName();
                if (this.isOptionalResolver(resolver, parameter)) {
                    ++optionalResolvers;
                    if (resolver instanceof IssuerOnlyContextResolver) continue;
                    syntaxB.append('[').append(name).append("] ");
                    continue;
                }
                ++requiredResolvers;
                syntaxB.append('<').append(name).append("> ");
                continue;
            }
            ACFUtil.sneaky(new InvalidCommandContextException("Parameter " + type.getSimpleName() + " of " + this.command + " has no applicable context resolver"));
        }
        String syntaxText = syntaxB.toString();
        this.syntaxText = this.manager.getCommandReplacements().replace(syntaxStr != null ? ACFUtil.replace(syntaxStr.value(), "@syntax", syntaxText) : syntaxText);
        this.requiredResolvers = requiredResolvers;
        this.optionalResolvers = optionalResolvers;
    }

    private boolean isOptionalResolver(ContextResolver<?, CEC> resolver, Parameter parameter) {
        return this.isOptionalResolver(resolver) || parameter.getAnnotation(Optional.class) != null || parameter.getAnnotation(Default.class) != null;
    }

    private boolean isOptionalResolver(ContextResolver<?, CEC> resolver) {
        return resolver instanceof IssuerAwareContextResolver || resolver instanceof IssuerOnlyContextResolver || resolver instanceof OptionalContextResolver;
    }

    void invoke(CommandIssuer sender, List<String> args, CommandOperationContext context) {
        if (!this.scope.canExecute(sender, this)) {
            return;
        }
        this.preCommand();
        try {
            this.manager.conditions.validateConditions(context);
            Map<String, Object> passedArgs = this.resolveContexts(sender, args);
            if (passedArgs == null) {
                return;
            }
            this.method.invoke((Object)this.scope, passedArgs.values().toArray());
        }
        catch (Exception e) {
            this.handleException(sender, args, e);
        }
        this.postCommand();
    }

    public void preCommand() {
    }

    public void postCommand() {
    }

    void handleException(CommandIssuer sender, List<String> args, Exception e) {
        if (e instanceof InvocationTargetException && e.getCause() instanceof InvalidCommandArgument) {
            e = (Exception)e.getCause();
        }
        if (e instanceof ShowCommandHelp) {
            ShowCommandHelp showHelp = (ShowCommandHelp)e;
            CommandHelp commandHelp = this.manager.generateCommandHelp();
            if (showHelp.search) {
                commandHelp.setSearch(showHelp.searchArgs == null ? args : showHelp.searchArgs);
            }
            commandHelp.showHelp(sender);
        } else if (e instanceof InvalidCommandArgument) {
            InvalidCommandArgument invalidCommandArg = (InvalidCommandArgument)e;
            if (invalidCommandArg.key != null) {
                sender.sendMessage(MessageType.ERROR, invalidCommandArg.key, invalidCommandArg.replacements);
            } else if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                sender.sendMessage(MessageType.ERROR, MessageKeys.ERROR_PREFIX, "{message}", e.getMessage());
            }
            if (invalidCommandArg.showSyntax) {
                this.scope.showSyntax(sender, this);
            }
        } else {
            try {
                if (!this.manager.handleUncaughtException(this.scope, this, sender, args, e)) {
                    sender.sendMessage(MessageType.ERROR, MessageKeys.ERROR_PERFORMING_COMMAND, new String[0]);
                }
                this.manager.log(LogLevel.ERROR, "Exception in command: " + this.command + " " + ACFUtil.join(args), e);
            }
            catch (Exception e2) {
                this.manager.log(LogLevel.ERROR, "Exception in handleException for command: " + this.command + " " + ACFUtil.join(args), e);
                this.manager.log(LogLevel.ERROR, "Exception triggered by exception handler:", e2);
            }
        }
    }

    @Nullable
    Map<String, Object> resolveContexts(CommandIssuer sender, List<String> args) throws InvalidCommandArgument {
        return this.resolveContexts(sender, args, this.parameters.length);
    }

    @Nullable
    Map<String, Object> resolveContexts(CommandIssuer sender, List<String> args, int argLimit) throws InvalidCommandArgument {
        args = Lists.newArrayList(args);
        String[] origArgs = args.toArray(new String[args.size()]);
        LinkedHashMap passedArgs = Maps.newLinkedHashMap();
        int remainingRequired = this.requiredResolvers;
        CommandOperationContext opContext = CommandManager.getCurrentCommandOperationContext();
        for (int i = 0; i < this.parameters.length && i < argLimit; ++i) {
            Values values;
            boolean isLast = i == this.parameters.length - 1;
            boolean allowOptional = remainingRequired == 0;
            Parameter parameter = this.parameters[i];
            String parameterName = parameter.getName();
            Class<?> type = parameter.getType();
            ContextResolver<?, CEC> resolver = this.resolvers[i];
            CommandExecutionContext context = this.manager.createCommandContext(this, parameter, sender, args, i, passedArgs);
            boolean isOptionalResolver = this.isOptionalResolver(resolver, parameter);
            if (!isOptionalResolver) {
                --remainingRequired;
            }
            if (args.isEmpty() && (!isLast || type != String[].class)) {
                Default def = parameter.getAnnotation(Default.class);
                Optional opt = parameter.getAnnotation(Optional.class);
                if (allowOptional && def != null) {
                    args.add(this.scope.manager.getCommandReplacements().replace(def.value()));
                } else {
                    if (allowOptional && opt != null) {
                        Object value;
                        Object v = value = this.isOptionalResolver(resolver) ? (Object)resolver.getContext(context) : null;
                        if (value == null && parameter.getClass().isPrimitive()) {
                            throw new IllegalStateException("Parameter " + parameter.getName() + " is primitive and does not support Optional.");
                        }
                        this.manager.conditions.validateConditions(context, value);
                        passedArgs.put(parameterName, value);
                        continue;
                    }
                    if (!isOptionalResolver) {
                        this.scope.showSyntax(sender, this);
                        return null;
                    }
                }
            }
            if ((values = parameter.getAnnotation(Values.class)) != null) {
                String arg = !args.isEmpty() ? (String)args.get(0) : "";
                String[] split = ACFPatterns.PIPE.split(this.scope.manager.getCommandReplacements().replace(values.value()));
                HashSet possible = Sets.newHashSet();
                for (String s : split) {
                    List<String> check = this.manager.getCommandCompletions().getCompletionValues(this, sender, s, origArgs, opContext.isAsync());
                    if (!check.isEmpty()) {
                        possible.addAll(check.stream().map(String::toLowerCase).collect(Collectors.toList()));
                        continue;
                    }
                    possible.add(s.toLowerCase());
                }
                if (!possible.contains(arg.toLowerCase())) {
                    throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", ACFUtil.join(possible, ", "));
                }
            }
            Object paramValue = resolver.getContext(context);
            this.manager.conditions.validateConditions(context, paramValue);
            passedArgs.put(parameterName, paramValue);
        }
        return passedArgs;
    }

    boolean hasPermission(CommandIssuer issuer) {
        return (this.permission == null || this.permission.isEmpty() || this.scope.manager.hasPermission(issuer, this.permission)) && this.scope.hasPermission(issuer);
    }

    @Deprecated
    public String getPermission() {
        if (this.permission == null || this.permission.isEmpty()) {
            return null;
        }
        return ACFPatterns.COMMA.split(this.permission)[0];
    }

    public Set<String> getRequiredPermissions() {
        if (this.permission == null || this.permission.isEmpty()) {
            return ImmutableSet.of();
        }
        return Sets.newHashSet((Object[])ACFPatterns.COMMA.split(this.permission));
    }

    public boolean requiresPermission(String permission) {
        return this.getRequiredPermissions().contains(permission) || this.scope.requiresPermission(permission);
    }

    public String getPrefSubCommand() {
        return this.prefSubCommand;
    }

    public String getSyntaxText() {
        return this.syntaxText;
    }

    public String getCommand() {
        return this.command;
    }

    public void addSubcommand(String cmd) {
        this.registeredSubcommands.add(cmd);
    }

    public void addSubcommands(Collection<String> cmd) {
        this.registeredSubcommands.addAll(cmd);
    }
}

