/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.annotation.Conditions;
import com.google.common.collect.Maps;
import java.util.Map;

public class ConditionContext<I extends CommandIssuer> {
    private final RegisteredCommand cmd;
    private final I issuer;
    private final Conditions condAnno;
    private final Map<String, String> flags;

    ConditionContext(RegisteredCommand cmd, I issuer, Conditions condAnno) {
        this.cmd = cmd;
        this.issuer = issuer;
        this.condAnno = condAnno;
        this.flags = Maps.newHashMap();
        for (String s : ACFPatterns.COMMA.split(cmd.scope.manager.getCommandReplacements().replace(condAnno.value()))) {
            String[] v = ACFPatterns.EQUALS.split(s, 2);
            this.flags.put(v[0], v.length > 1 ? v[1] : null);
        }
    }

    public I getIssuer() {
        return this.issuer;
    }

    public boolean hasFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    public String getFlagValue(String flag, String def) {
        return this.flags.getOrDefault(flag, def);
    }

    public Integer getFlagValue(String flag, Integer def) {
        return ACFUtil.parseInt(this.flags.get(flag), def);
    }
}

