/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.ConditionContext;
import co.aikar.commands.ParameterConditionContext;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.annotation.Conditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Map;

public class CommandConditions<I extends CommandIssuer, M extends CommandManager, CC extends ConditionContext, CEC extends CommandExecutionContext<CEC, I>, PCC extends ParameterConditionContext<?, CEC, I>> {
    M manager;
    Map<String, Condition<CC>> conditions = Maps.newHashMap();
    Table<Class<?>, String, ParameterCondition<PCC>> paramConditions = HashBasedTable.create();

    CommandConditions(M manager) {
        this.manager = manager;
    }

    Condition<CC> addCondition(String id, Condition<CC> handler) {
        return this.conditions.put(id.toLowerCase(), handler);
    }

    <P> ParameterCondition addCondition(Class<P> clazz, String id, ParameterCondition<PCC> handler) {
        return (ParameterCondition)this.paramConditions.put(clazz, (Object)id.toLowerCase(), handler);
    }

    boolean validateConditions(CommandOperationContext context, CEC cec) {
        Conditions conditions = ((CommandExecutionContext)cec).getParam().getAnnotation(Conditions.class);
        return conditions == null || this.validateConditions(conditions, context, cec);
    }

    boolean validateConditions(CommandOperationContext context) {
        RegisteredCommand cmd = context.getRegisteredCommand();
        Conditions conditions = cmd.method.getAnnotation(Conditions.class);
        if (conditions != null && !this.validateConditions(conditions, context)) {
            return false;
        }
        return this.validateConditions(cmd.scope, context);
    }

    private boolean validateConditions(BaseCommand scope, CommandOperationContext operationContext) {
        Conditions conditions = scope.getClass().getAnnotation(Conditions.class);
        if (!this.validateConditions(conditions, operationContext)) {
            return false;
        }
        return scope.parentCommand == null || this.validateConditions(scope.parentCommand, operationContext);
    }

    private boolean validateConditions(Conditions condAnno, CommandOperationContext context) {
        if (condAnno == null) {
            return true;
        }
        ConditionContext conditionContext = ((CommandManager)this.manager).createConditionContext(context, condAnno);
        String conditions = ((CommandManager)this.manager).getCommandReplacements().replace(condAnno.value());
        for (String cond : ACFPatterns.PIPE.split(conditions)) {
            String[] split = ACFPatterns.EQUALS.split(cond, 2);
            Condition<ConditionContext> condition = this.conditions.get(split[0].toLowerCase());
            if (condition.validateCondition(conditionContext)) continue;
            return false;
        }
        return true;
    }

    private boolean validateConditions(Conditions condAnno, CommandOperationContext context, CEC execContext) {
        if (condAnno == null) {
            return true;
        }
        ParameterConditionContext conditionContext = ((CommandManager)this.manager).createConditionContext(context, execContext, condAnno);
        String conditions = ((CommandManager)this.manager).getCommandReplacements().replace(condAnno.value());
        for (String cond : ACFPatterns.PIPE.split(conditions)) {
            ParameterCondition condition;
            String[] split = ACFPatterns.EQUALS.split(cond, 2);
            Class<?> cls = ((CommandExecutionContext)execContext).getParam().getClass();
            String id = split[0].toLowerCase();
            while ((condition = (ParameterCondition)this.paramConditions.get(cls, (Object)id)) == null && cls.getSuperclass() != null && cls.getSuperclass() != Object.class && (cls = cls.getSuperclass()) != null) {
            }
            if (condition == null || condition.validateCondition(conditionContext)) continue;
            return false;
        }
        return true;
    }

    static interface ParameterCondition<PCC extends ParameterConditionContext> {
        public boolean validateCondition(PCC var1);
    }

    static interface Condition<CC extends ConditionContext> {
        public boolean validateCondition(CC var1);
    }
}

