/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Flags;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.contexts.ContextResolver;
import co.aikar.commands.contexts.IssuerAwareContextResolver;
import co.aikar.commands.contexts.IssuerOnlyContextResolver;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;

public class CommandExecutionContext<T extends CommandExecutionContext, I extends CommandIssuer> {
    private final RegisteredCommand cmd;
    private final Parameter param;
    protected final I issuer;
    private final List<String> args;
    private final int index;
    private final Map<String, Object> passedArgs;
    private final Map<String, String> flags;

    CommandExecutionContext(RegisteredCommand cmd, Parameter param, I sender, List<String> args, int index, Map<String, Object> passedArgs) {
        this.cmd = cmd;
        this.param = param;
        this.issuer = sender;
        this.args = args;
        this.index = index;
        this.passedArgs = passedArgs;
        Flags flags = param.getAnnotation(Flags.class);
        if (flags != null) {
            this.flags = Maps.newHashMap();
            for (String s : ACFPatterns.COMMA.split(cmd.scope.manager.getCommandReplacements().replace(flags.value()))) {
                String[] v = ACFPatterns.EQUALS.split(s, 2);
                this.flags.put(v[0], v.length > 1 ? v[1] : null);
            }
        } else {
            this.flags = ImmutableMap.of();
        }
    }

    public String popFirstArg() {
        return !this.args.isEmpty() ? this.args.remove(0) : null;
    }

    public String popLastArg() {
        return !this.args.isEmpty() ? this.args.remove(this.args.size() - 1) : null;
    }

    public String getFirstArg() {
        return !this.args.isEmpty() ? this.args.get(0) : null;
    }

    public String getLastArg() {
        return !this.args.isEmpty() ? this.args.get(this.args.size() - 1) : null;
    }

    public boolean isLastArg() {
        return this.cmd.parameters.length - 1 == this.index;
    }

    public int getNumParams() {
        return this.cmd.parameters.length;
    }

    public boolean canOverridePlayerContext() {
        int numRequired = this.getNumParams();
        for (int i = 0; i < this.cmd.resolvers.length; ++i) {
            Parameter parameter = this.cmd.parameters[i];
            ContextResolver resolver = this.cmd.resolvers[i];
            if (parameter.getAnnotation(Optional.class) != null || parameter.getAnnotation(Default.class) != null) {
                --numRequired;
                continue;
            }
            if (!(resolver instanceof IssuerAwareContextResolver) && !(resolver instanceof IssuerOnlyContextResolver)) continue;
            --numRequired;
        }
        return numRequired >= this.args.size();
    }

    public Object getResolvedArg(String arg) {
        return this.passedArgs.get(arg);
    }

    public Object getResolvedArg(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            for (Object passedArg : this.passedArgs.values()) {
                if (!clazz.isInstance(passedArg)) continue;
                return passedArg;
            }
        }
        return null;
    }

    public <T> T getResolvedArg(String key, Class<?> ... classes) {
        Object o = this.passedArgs.get(key);
        for (Class<?> clazz : classes) {
            if (!clazz.isInstance(o)) continue;
            return (T)o;
        }
        return null;
    }

    public boolean isOptional() {
        return this.param.getAnnotation(Optional.class) != null;
    }

    public boolean hasFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    public String getFlagValue(String flag, String def) {
        return this.flags.getOrDefault(flag, def);
    }

    public Integer getFlagValue(String flag, Integer def) {
        return ACFUtil.parseInt(this.flags.get(flag), def);
    }

    public <T extends Annotation> T getAnnotation(Class<T> cls) {
        return this.param.getAnnotation(cls);
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> cls) {
        return this.param.getAnnotation(cls) != null;
    }

    public RegisteredCommand getCmd() {
        return this.cmd;
    }

    public Parameter getParam() {
        return this.param;
    }

    public I getIssuer() {
        return this.issuer;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public int getIndex() {
        return this.index;
    }

    public Map<String, Object> getPassedArgs() {
        return this.passedArgs;
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }

    public String joinArgs() {
        return ACFUtil.join(this.args, " ");
    }

    public String joinArgs(String sep) {
        return ACFUtil.join(this.args, sep);
    }
}

