/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandCompletionTextLookupException;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.LogLevel;
import co.aikar.commands.RegisteredCommand;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;

public class CommandCompletionContext {
    private final RegisteredCommand command;
    protected final CommandIssuer issuer;
    private final String input;
    private final String config;
    private final Map<String, String> configs = Maps.newHashMap();
    private final List<String> args;

    CommandCompletionContext(RegisteredCommand command, CommandIssuer issuer, String input, String config, String[] args) {
        this.command = command;
        this.issuer = issuer;
        this.input = input;
        if (config != null) {
            String[] configs;
            for (String conf : configs = ACFPatterns.COMMA.split(config)) {
                String[] confsplit = ACFPatterns.EQUALS.split(conf, 2);
                this.configs.put(confsplit[0].toLowerCase(), confsplit.length > 1 ? confsplit[1] : null);
            }
            this.config = configs[0];
        } else {
            this.config = null;
        }
        this.args = Lists.newArrayList((Object[])args);
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public String getConfig(String key) {
        return this.getConfig(key, null);
    }

    public String getConfig(String key, String def) {
        return this.configs.getOrDefault(key.toLowerCase(), def);
    }

    public boolean hasConfig(String key) {
        return this.configs.containsKey(key.toLowerCase());
    }

    public <T> T getContextValue(Class<? extends T> clazz) throws InvalidCommandArgument {
        return this.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<? extends T> clazz, Integer paramIdx) throws InvalidCommandArgument {
        String name = null;
        if (paramIdx != null) {
            if (paramIdx >= this.command.parameters.length) {
                throw new IllegalArgumentException("Param index is higher than number of parameters");
            }
            Parameter param = this.command.parameters[paramIdx];
            Class<?> paramType = param.getType();
            if (!clazz.isAssignableFrom(paramType)) {
                throw new IllegalArgumentException(param.getName() + ":" + paramType.getName() + " can not satisfy " + clazz.getName());
            }
            name = param.getName();
        } else {
            Parameter[] parameters = this.command.parameters;
            for (int i = 0; i < parameters.length; ++i) {
                Parameter param = parameters[i];
                if (!clazz.isAssignableFrom(param.getType())) continue;
                paramIdx = i;
                name = param.getName();
                break;
            }
            if (paramIdx == null) {
                throw new IllegalStateException("Can not find any parameter that can satisfy " + clazz.getName());
            }
        }
        Map<String, Object> resolved = this.command.resolveContexts(this.issuer, this.args, this.args.size());
        if (resolved == null || paramIdx > resolved.size()) {
            this.command.scope.manager.log(LogLevel.ERROR, "resolved: " + resolved + " paramIdx: " + paramIdx + " - size: " + (resolved != null ? Integer.valueOf(resolved.size()) : null));
            ACFUtil.sneaky(new CommandCompletionTextLookupException());
        }
        return (T)resolved.get(name);
    }

    public CommandIssuer getIssuer() {
        return this.issuer;
    }

    public String getInput() {
        return this.input;
    }

    public String getConfig() {
        return this.config;
    }

    public boolean isAsync() {
        return CommandManager.getCurrentCommandOperationContext().isAsync();
    }
}

