/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.locales;

import co.aikar.locales.MessageKey;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;

public class LanguageTable {
    private final Locale locale;
    private final Map<MessageKey, String> messages = new HashMap<MessageKey, String>();

    LanguageTable(Locale locale) {
        this.locale = locale;
    }

    public String addMessage(MessageKey key, String message) {
        return this.messages.put(key, message);
    }

    public String getMessage(MessageKey key) {
        return this.messages.get(key);
    }

    public void addMessages(@NotNull Map<MessageKey, String> messages) {
        this.messages.putAll(messages);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean addMessageBundle(String bundleName) {
        try {
            boolean found = false;
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, this.locale);
            for (String key : bundle.keySet()) {
                found = true;
                this.addMessage(MessageKey.of(key), bundle.getString(key));
            }
            return found;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }
}

