/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Syntax;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class BukkitRootCommand
extends Command
implements RootCommand {
    private final BukkitCommandManager manager;
    private final String name;
    private BaseCommand defCommand;
    private SetMultimap<String, RegisteredCommand> subCommands = HashMultimap.create();
    private List<BaseCommand> children = new ArrayList<BaseCommand>();
    boolean isRegistered = false;

    BukkitRootCommand(BukkitCommandManager manager, String name) {
        super(name);
        this.manager = manager;
        this.name = name;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return this.tabComplete(this.manager.getCommandIssuer(sender), alias, args);
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        this.execute(this.manager.getCommandIssuer(sender), commandLabel, args);
        return true;
    }

    private List<String> tabComplete(CommandIssuer sender, String alias, String[] args) throws IllegalArgumentException {
        HashSet completions = new HashSet();
        this.children.forEach(child -> completions.addAll(child.tabComplete(sender, alias, args)));
        return new ArrayList<String>(completions);
    }

    @Override
    public void addChild(BaseCommand command) {
        if (this.defCommand == null || !command.subCommands.get((Object)"__default").isEmpty()) {
            this.defCommand = command;
            this.setPermission(command.permission);
        }
        this.addChildShared(this.children, this.subCommands, command);
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public SetMultimap<String, RegisteredCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public BaseCommand getDefCommand() {
        return this.defCommand;
    }

    public String getDescription() {
        Description descAnno;
        RegisteredCommand cmd = this.getDefaultRegisteredCommand();
        if (cmd != null) {
            return cmd.helpText;
        }
        BaseCommand defCommand = this.getDefCommand();
        if (defCommand != null && (descAnno = defCommand.getClass().getAnnotation(Description.class)) != null) {
            return descAnno.value();
        }
        return "";
    }

    public String getUsage() {
        Syntax syntaxAnno;
        RegisteredCommand cmd = this.getDefaultRegisteredCommand();
        if (cmd != null) {
            return cmd.syntaxText;
        }
        BaseCommand defCommand = this.getDefCommand();
        if (defCommand != null && (syntaxAnno = defCommand.getClass().getAnnotation(Syntax.class)) != null) {
            return syntaxAnno.value();
        }
        return "";
    }
}

