/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandCompletionContext;
import co.aikar.commands.BukkitCommandCompletions;
import co.aikar.commands.BukkitCommandContexts;
import co.aikar.commands.BukkitCommandExecutionContext;
import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.BukkitLocales;
import co.aikar.commands.BukkitMessageFormatter;
import co.aikar.commands.BukkitRegisteredCommand;
import co.aikar.commands.BukkitRootCommand;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageType;
import co.aikar.commands.ProxyCommandMap;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.apachecommonslang.ApacheCommonsExceptionUtil;
import co.aikar.timings.lib.MCTiming;
import co.aikar.timings.lib.TimingManager;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class BukkitCommandManager
extends CommandManager<CommandSender, BukkitCommandIssuer, ChatColor, BukkitMessageFormatter> {
    protected final Plugin plugin;
    private final CommandMap commandMap;
    private final TimingManager timingManager;
    private final BukkitTask localeTask;
    protected Map<String, Command> knownCommands = new HashMap<String, Command>();
    protected Map<String, BukkitRootCommand> registeredCommands = new HashMap<String, BukkitRootCommand>();
    protected BukkitCommandContexts contexts;
    protected BukkitCommandCompletions completions;
    MCTiming commandTiming;
    protected BukkitLocales locales;
    private boolean cantReadLocale = false;
    protected Map<UUID, Locale> issuersLocale = Maps.newConcurrentMap();

    public BukkitCommandManager(Plugin plugin) {
        this.plugin = plugin;
        this.timingManager = TimingManager.of(plugin);
        this.commandTiming = this.timingManager.of("Commands");
        this.commandMap = this.hookCommandMap();
        this.defaultFormatter = new BukkitMessageFormatter(ChatColor.RED, ChatColor.YELLOW, ChatColor.RED);
        this.formatters.put(MessageType.ERROR, this.defaultFormatter);
        this.formatters.put(MessageType.SYNTAX, new BukkitMessageFormatter(ChatColor.YELLOW, ChatColor.GREEN, ChatColor.WHITE));
        this.formatters.put(MessageType.INFO, new BukkitMessageFormatter(ChatColor.BLUE, ChatColor.DARK_GREEN, ChatColor.GREEN));
        this.formatters.put(MessageType.HELP, new BukkitMessageFormatter(ChatColor.AQUA, ChatColor.GREEN, ChatColor.YELLOW));
        Bukkit.getPluginManager().registerEvents((Listener)new ACFBukkitListener(plugin), plugin);
        this.getLocales();
        this.localeTask = Bukkit.getScheduler().runTaskTimer(plugin, () -> {
            if (this.cantReadLocale) {
                return;
            }
            Bukkit.getOnlinePlayers().forEach(this::readPlayerLocale);
        }, 5L, 5L);
    }

    @NotNull
    private CommandMap hookCommandMap() {
        Object commandMap = null;
        try {
            Server server = Bukkit.getServer();
            Method getCommandMap = server.getClass().getDeclaredMethod("getCommandMap", new Class[0]);
            getCommandMap.setAccessible(true);
            commandMap = (CommandMap)getCommandMap.invoke((Object)server, new Object[0]);
            if (!SimpleCommandMap.class.isAssignableFrom(commandMap.getClass())) {
                this.log(LogLevel.ERROR, "ERROR: CommandMap has been hijacked! Offending command map is located at: " + commandMap.getClass().getName());
                this.log(LogLevel.ERROR, "We are going to try to hijack it back and resolve this, but you are now in dangerous territory.");
                this.log(LogLevel.ERROR, "We can not guarantee things are going to work.");
                Field cmField = server.getClass().getDeclaredField("commandMap");
                commandMap = new ProxyCommandMap(this, (CommandMap)commandMap);
                cmField.set(server, commandMap);
                this.log(LogLevel.INFO, "Injected Proxy Command Map... good luck...");
            }
            Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommands.setAccessible(true);
            this.knownCommands = (Map)knownCommands.get(commandMap);
        }
        catch (Exception e) {
            this.log(LogLevel.ERROR, "Failed to get Command Map. ACF will not function.");
            ACFUtil.sneaky(e);
        }
        return commandMap;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isCommandIssuer(Class<?> type) {
        return CommandSender.class.isAssignableFrom(type);
    }

    @Override
    public synchronized CommandContexts<BukkitCommandExecutionContext> getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = new BukkitCommandContexts(this);
        }
        return this.contexts;
    }

    @Override
    public synchronized CommandCompletions<BukkitCommandCompletionContext> getCommandCompletions() {
        if (this.completions == null) {
            this.completions = new BukkitCommandCompletions(this);
        }
        return this.completions;
    }

    @Override
    public BukkitLocales getLocales() {
        if (this.locales == null) {
            this.locales = new BukkitLocales(this);
            this.locales.loadLanguages();
        }
        return this.locales;
    }

    @Override
    public boolean hasRegisteredCommands() {
        return !this.registeredCommands.isEmpty();
    }

    public void registerCommand(BaseCommand command, boolean force) {
        String plugin = this.plugin.getName().toLowerCase();
        command.onRegister(this);
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase();
            BukkitRootCommand bukkitCommand = (BukkitRootCommand)entry.getValue();
            if (!bukkitCommand.isRegistered) {
                if (force && this.knownCommands.containsKey(commandName)) {
                    Command oldCommand = this.commandMap.getCommand(commandName);
                    this.knownCommands.remove(commandName);
                    for (Map.Entry<String, Command> ce : this.knownCommands.entrySet()) {
                        String[] split;
                        String key = ce.getKey();
                        Command value = ce.getValue();
                        if (!key.contains(":") || !oldCommand.equals(value) || (split = ACFPatterns.COLON.split(key, 2)).length <= 1) continue;
                        oldCommand.unregister(this.commandMap);
                        oldCommand.setLabel(split[0] + ":" + command.getName());
                        oldCommand.register(this.commandMap);
                    }
                }
                this.commandMap.register(commandName, plugin, (Command)bukkitCommand);
            }
            bukkitCommand.isRegistered = true;
            this.registeredCommands.put(commandName, bukkitCommand);
        }
    }

    @Override
    public void registerCommand(BaseCommand command) {
        this.registerCommand(command, false);
    }

    public void unregisterCommand(BaseCommand command) {
        for (RootCommand rootcommand : command.registeredCommands.values()) {
            BukkitRootCommand bukkitCommand = (BukkitRootCommand)rootcommand;
            bukkitCommand.getSubCommands().values().removeAll(command.subCommands.values());
            if (!bukkitCommand.isRegistered || !bukkitCommand.getSubCommands().isEmpty()) continue;
            this.unregisterCommand(bukkitCommand);
            bukkitCommand.isRegistered = false;
        }
    }

    @Deprecated
    public void unregisterCommand(BukkitRootCommand command) {
        String plugin = this.plugin.getName().toLowerCase();
        command.unregister(this.commandMap);
        String key = command.getName();
        Command registered = this.knownCommands.get(key);
        if (command.equals(registered)) {
            this.knownCommands.remove(key);
        }
        this.knownCommands.remove(plugin + ":" + key);
    }

    public void unregisterCommands() {
        for (Map.Entry<String, BukkitRootCommand> entry : this.registeredCommands.entrySet()) {
            this.unregisterCommand(entry.getValue());
        }
        this.registeredCommands.clear();
    }

    private Field getEntityField(Player player) throws NoSuchFieldException {
        for (Class<?> cls = player.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            if (!cls.getName().endsWith("CraftEntity")) continue;
            Field field = cls.getDeclaredField("entity");
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private void readPlayerLocale(Player player) {
        if (!player.isOnline() || this.cantReadLocale) {
            return;
        }
        try {
            Locale prev;
            String[] split;
            Locale locale;
            Field localeField;
            Object localeString;
            Field entityField = this.getEntityField(player);
            if (entityField == null) {
                return;
            }
            Object nmsPlayer = entityField.get(player);
            if (nmsPlayer != null && (localeString = (localeField = nmsPlayer.getClass().getField("locale")).get(nmsPlayer)) != null && localeString instanceof String && !Objects.equals(locale = (split = ACFPatterns.UNDERSCORE.split((String)localeString)).length > 1 ? new Locale(split[0], split[1]) : new Locale(split[0]), prev = this.issuersLocale.put(player.getUniqueId(), locale))) {
                this.notifyLocaleChange(this.getCommandIssuer(player), prev, locale);
            }
        }
        catch (Exception e) {
            this.cantReadLocale = true;
            this.localeTask.cancel();
            this.log(LogLevel.INFO, "Can't read players locale, you will be unable to automatically detect players language. Only Bukkit 1.7+ is supported for this.", e);
        }
    }

    public TimingManager getTimings() {
        return this.timingManager;
    }

    @Override
    public RootCommand createRootCommand(String cmd) {
        return new BukkitRootCommand(this, cmd);
    }

    @Override
    public BukkitCommandIssuer getCommandIssuer(Object issuer) {
        if (!(issuer instanceof CommandSender)) {
            throw new IllegalArgumentException(issuer.getClass().getName() + " is not a Command Issuer.");
        }
        return new BukkitCommandIssuer(this, (CommandSender)issuer);
    }

    @Override
    public <R extends CommandExecutionContext> R createCommandContext(RegisteredCommand command, Parameter parameter, CommandIssuer sender, List<String> args, int i, Map<String, Object> passedArgs) {
        return (R)new BukkitCommandExecutionContext(command, parameter, (BukkitCommandIssuer)sender, args, i, passedArgs);
    }

    @Override
    public CommandCompletionContext createCompletionContext(RegisteredCommand command, CommandIssuer sender, String input, String config, String[] args) {
        return new BukkitCommandCompletionContext(command, sender, input, config, args);
    }

    @Override
    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new BukkitRegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        Logger logger = this.plugin.getLogger();
        Level logLevel = level == LogLevel.INFO ? Level.INFO : Level.SEVERE;
        logger.log(logLevel, "[ACF] " + message);
        if (throwable != null) {
            for (String line : ACFPatterns.NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(throwable))) {
                logger.log(logLevel, "[ACF] " + line);
            }
        }
    }

    @Override
    public Locale getIssuerLocale(CommandIssuer issuer) {
        UUID uniqueId = ((Player)issuer.getIssuer()).getUniqueId();
        Locale locale = this.issuersLocale.get(uniqueId);
        if (locale != null) {
            return locale;
        }
        return super.getIssuerLocale(issuer);
    }

    private class ACFBukkitListener
    implements Listener {
        private final Plugin plugin;

        public ACFBukkitListener(Plugin plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (!this.plugin.getName().equalsIgnoreCase(event.getPlugin().getName())) {
                return;
            }
            BukkitCommandManager.this.unregisterCommands();
        }

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            BukkitCommandManager.this.readPlayerLocale(player);
            this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> BukkitCommandManager.this.readPlayerLocale(player), 20L);
        }

        @EventHandler
        public void onPlayerJoin(PlayerQuitEvent event) {
            BukkitCommandManager.this.issuersLocale.remove(event.getPlayer().getUniqueId());
        }
    }
}

