/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CommandReplacements {
    private final CommandManager manager;
    private final Map<String, Map.Entry<Pattern, String>> replacements = new LinkedHashMap<String, Map.Entry<Pattern, String>>();

    CommandReplacements(CommandManager manager) {
        this.manager = manager;
        this.addReplacement("truthy", "true|false|yes|no|1|0|on|off|t|f");
    }

    public void addReplacements(String ... replacements) {
        if (replacements.length == 0 || replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Must pass a number of arguments divisible by 2.");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            this.addReplacement(replacements[i], replacements[i + 1]);
        }
    }

    public String addReplacement(String key, String val) {
        Pattern pattern;
        AbstractMap.SimpleImmutableEntry<Pattern, String> entry;
        Map.Entry replaced;
        if (this.manager.hasRegisteredCommands()) {
            this.manager.log(LogLevel.ERROR, "You are registering replacements after you have registered your commands!");
            this.manager.log(LogLevel.ERROR, "This is not allowed, and this replacement (" + key + ") will not work for any previously registered command.");
        }
        if ((replaced = (Map.Entry)this.replacements.put(key = ACFPatterns.PERCENTAGE.matcher(key.toLowerCase()).replaceAll(""), entry = new AbstractMap.SimpleImmutableEntry<Pattern, String>(pattern = Pattern.compile("%" + Pattern.quote(key) + "\\b", 2), val))) != null) {
            return (String)replaced.getValue();
        }
        return null;
    }

    public String replace(String text) {
        if (text == null) {
            return null;
        }
        for (Map.Entry<Pattern, String> entry : this.replacements.values()) {
            text = entry.getKey().matcher(text).replaceAll(entry.getValue());
        }
        return this.manager.getLocales().replaceI18NStrings(text);
    }
}

