/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.HelpEntry;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MessageType;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.UnstableAPI;
import co.aikar.locales.MessageKeyProvider;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CommandHelp {
    private final CommandManager manager;
    private final CommandIssuer issuer;
    private final List<HelpEntry> helpEntries = new ArrayList<HelpEntry>();
    private int page;
    private int perPage;
    private List<String> search;

    public CommandHelp(CommandManager manager, RootCommand rootCommand, CommandIssuer issuer) {
        this.manager = manager;
        this.issuer = issuer;
        this.perPage = manager.defaultHelpPerPage;
        SetMultimap<String, RegisteredCommand> subCommands = rootCommand.getSubCommands();
        HashSet seen = new HashSet();
        subCommands.entries().forEach(e -> {
            String key = (String)e.getKey();
            if (key.equals("__default") || key.equals("__unknown")) {
                return;
            }
            RegisteredCommand regCommand = (RegisteredCommand)e.getValue();
            if (regCommand.hasPermission(issuer) && !seen.contains(regCommand)) {
                this.helpEntries.add(new HelpEntry(regCommand));
                seen.add(regCommand);
            }
        });
    }

    @UnstableAPI
    protected void updateSearchScore(HelpEntry help) {
        if (this.search == null || this.search.isEmpty()) {
            help.setSearchScore(1);
            return;
        }
        RegisteredCommand cmd = help.getRegisteredCommand();
        int searchScore = 0;
        for (String word : this.search) {
            Pattern pattern = Pattern.compile(".*" + Pattern.quote(word) + ".*", 2);
            for (String subCmd : cmd.registeredSubcommands) {
                Pattern subCmdPattern = Pattern.compile(".*" + Pattern.quote(subCmd) + ".*", 2);
                if (pattern.matcher(subCmd).matches()) {
                    searchScore += 3;
                    continue;
                }
                if (!subCmdPattern.matcher(word).matches()) continue;
                ++searchScore;
            }
            if (pattern.matcher(help.getDescription()).matches()) {
                searchScore += 2;
            }
            if (pattern.matcher(help.getParameterSyntax()).matches()) {
                ++searchScore;
            }
            if (help.getSearchTags() == null || !pattern.matcher(help.getSearchTags()).matches()) continue;
            searchScore += 2;
        }
        help.setSearchScore(searchScore);
    }

    public CommandManager getManager() {
        return this.manager;
    }

    public void showHelp() {
        this.showHelp(this.issuer, MessageKeys.HELP_FORMAT);
    }

    public void showHelp(CommandIssuer issuer) {
        this.showHelp(issuer, MessageKeys.HELP_FORMAT);
    }

    public void showHelp(CommandIssuer issuer, MessageKeyProvider format) {
        List<HelpEntry> helpEntries = this.getHelpEntries();
        Iterator<Object> results = helpEntries.stream().filter(HelpEntry::shouldShow).sorted(Comparator.comparingInt(helpEntry -> helpEntry.getSearchScore() * -1)).iterator();
        if (!results.hasNext()) {
            issuer.sendMessage(MessageType.ERROR, MessageKeys.NO_COMMAND_MATCHED_SEARCH, "{search}", ACFUtil.join(this.search, " "));
            helpEntries = this.getHelpEntries();
            results = helpEntries.iterator();
        }
        int totalResults = helpEntries.size();
        int min = (this.page - 1) * this.perPage;
        int max = min + this.perPage;
        int i = 0;
        if (min >= totalResults) {
            issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_NO_RESULTS, new String[0]);
            return;
        }
        while (results.hasNext()) {
            HelpEntry e = (HelpEntry)results.next();
            if (i >= max) break;
            if (i++ < min) continue;
            String formatted = this.manager.formatMessage(issuer, MessageType.HELP, format, this.getFormatReplacements(e));
            for (String msg : ACFPatterns.NEWLINE.split(formatted)) {
                issuer.sendMessageInternal(ACFUtil.rtrim(msg));
            }
        }
        if (min > 0 || results.hasNext()) {
            issuer.sendMessage(MessageType.HELP, MessageKeys.HELP_PAGE_INFORMATION, "{page}", "" + this.page, "{totalpages}", "" + (int)Math.ceil((float)totalResults / (float)this.perPage), "{results}", "" + totalResults);
        }
    }

    @NotNull
    public String[] getFormatReplacements(HelpEntry e) {
        return new String[]{"{command}", e.getCommand(), "{parameters}", e.getParameterSyntax(), "{separator}", e.getDescription().isEmpty() ? "" : "-", "{description}", e.getDescription()};
    }

    public List<HelpEntry> getHelpEntries() {
        return this.helpEntries;
    }

    public void setPerPage(int perPage) {
        this.perPage = perPage;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setPage(int page, int perPage) {
        this.setPage(page);
        this.setPerPage(perPage);
    }

    public void setSearch(List<String> search) {
        this.search = search;
        this.getHelpEntries().forEach(this::updateSearchScore);
    }
}

