/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFBukkitUtil;
import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BukkitCommandContexts_1_12;
import co.aikar.commands.BukkitCommandExecutionContext;
import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MinecraftMessageKeys;
import co.aikar.commands.annotation.Optional;
import co.aikar.commands.contexts.OnlinePlayer;
import co.aikar.locales.MessageKeyProvider;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public class BukkitCommandContexts
extends CommandContexts<BukkitCommandExecutionContext> {
    public BukkitCommandContexts(BukkitCommandManager manager) {
        super(manager);
        this.registerContext(OnlinePlayer.class, c -> this.getOnlinePlayer((BukkitCommandIssuer)c.getIssuer(), c.popFirstArg(), c.hasAnnotation(Optional.class)));
        this.registerContext(OnlinePlayer[].class, c -> {
            BukkitCommandIssuer issuer = (BukkitCommandIssuer)c.getIssuer();
            String search = c.popFirstArg();
            boolean allowMissing = c.hasFlag("allowmissing");
            HashSet<OnlinePlayer> players = new HashSet<OnlinePlayer>();
            Pattern split = ACFPatterns.COMMA;
            String splitter = c.getFlagValue("splitter", (String)null);
            if (splitter != null) {
                split = Pattern.compile(Pattern.quote(splitter));
            }
            for (String lookup : split.split(search)) {
                OnlinePlayer player = this.getOnlinePlayer(issuer, lookup, allowMissing);
                if (player == null) continue;
                players.add(player);
            }
            if (players.isEmpty() && !c.hasFlag("allowempty")) {
                issuer.sendError(MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", search);
                throw new InvalidCommandArgument(false);
            }
            return players.toArray(new OnlinePlayer[players.size()]);
        });
        this.registerIssuerAwareContext(World.class, c -> {
            World world;
            String firstArg = c.getFirstArg();
            World world2 = world = firstArg != null ? Bukkit.getWorld((String)firstArg) : null;
            if (world != null) {
                c.popFirstArg();
            }
            if (world == null && c.getSender() instanceof Player) {
                world = ((Entity)c.getSender()).getWorld();
            }
            if (world == null) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.INVALID_WORLD, new String[0]);
            }
            return world;
        });
        this.registerIssuerAwareContext(CommandSender.class, BukkitCommandExecutionContext::getSender);
        this.registerIssuerAwareContext(Player.class, c -> {
            PlayerInventory inventory;
            Player player;
            Player player2 = player = c.getSender() instanceof Player ? (Player)c.getSender() : null;
            if (player == null && !c.hasAnnotation(Optional.class)) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.NOT_ALLOWED_ON_CONSOLE, false, new String[0]);
            }
            PlayerInventory playerInventory = inventory = player != null ? player.getInventory() : null;
            if (inventory != null && c.hasFlag("itemheld") && !ACFBukkitUtil.isValidItem(inventory.getItem(inventory.getHeldItemSlot()))) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.YOU_MUST_BE_HOLDING_ITEM, false, new String[0]);
            }
            return player;
        });
        this.registerContext(ChatColor.class, c -> {
            ChatColor match;
            String filter;
            String first = c.popFirstArg();
            Stream<ChatColor> colors = Stream.of(ChatColor.values());
            if (c.hasFlag("colorsonly")) {
                colors = colors.filter(color -> color.ordinal() <= 15);
            }
            if ((filter = c.getFlagValue("filter", (String)null)) != null) {
                String finalFilter = filter = ACFUtil.simplifyString(filter);
                colors = colors.filter(color -> finalFilter.equals(ACFUtil.simplifyString(color.name())));
            }
            if ((match = (ChatColor)ACFUtil.simpleMatch(ChatColor.class, first)) == null) {
                String valid = colors.map(color -> "<c2>" + ACFUtil.simplifyString(color.name()) + "</c2>").collect(Collectors.joining("<c1>,</c1> "));
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", valid);
            }
            return match;
        });
        this.registerContext(Location.class, c -> {
            String rest;
            String world;
            String input = c.popFirstArg();
            CommandSender sender = c.getSender();
            String[] split = ACFPatterns.COLON.split(input, 2);
            if (split.length == 0) {
                throw new InvalidCommandArgument(true);
            }
            if (split.length < 2 && !(sender instanceof Player) && !(sender instanceof BlockCommandSender)) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_WORLD, new String[0]);
            }
            Location sourceLoc = null;
            if (split.length == 2) {
                world = split[0];
                rest = split[1];
            } else if (sender instanceof Player) {
                sourceLoc = ((Player)sender).getLocation();
                world = sourceLoc.getWorld().getName();
                rest = split[0];
            } else if (sender instanceof BlockCommandSender) {
                sourceLoc = ((BlockCommandSender)sender).getBlock().getLocation();
                world = sourceLoc.getWorld().getName();
                rest = split[0];
            } else {
                throw new InvalidCommandArgument(true);
            }
            boolean rel = rest.startsWith("~");
            split = ACFPatterns.COMMA.split(rel ? rest.substring(1) : rest);
            if (split.length < 3) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_XYZ, new String[0]);
            }
            Double x = ACFUtil.parseDouble(split[0]);
            Double y = ACFUtil.parseDouble(split[1]);
            Double z = ACFUtil.parseDouble(split[2]);
            if (sourceLoc != null && rel) {
                x = x + sourceLoc.getX();
                y = y + sourceLoc.getY();
                z = z + sourceLoc.getZ();
            } else if (rel) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_CONSOLE_NOT_RELATIVE, new String[0]);
            }
            if (x == null || y == null || z == null) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_XYZ, new String[0]);
            }
            World worldObj = Bukkit.getWorld((String)world);
            if (worldObj == null) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.INVALID_WORLD, new String[0]);
            }
            if (split.length >= 5) {
                Float yaw = ACFUtil.parseFloat(split[3]);
                Float pitch = ACFUtil.parseFloat(split[4]);
                if (pitch == null || yaw == null) {
                    throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.LOCATION_PLEASE_SPECIFY_XYZ, new String[0]);
                }
                return new Location(worldObj, x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
            }
            return new Location(worldObj, x.doubleValue(), y.doubleValue(), z.doubleValue());
        });
        Pattern versionPattern = Pattern.compile("\\(MC: (\\d)\\.(\\d+)\\.?.*?\\)");
        Matcher matcher = versionPattern.matcher(Bukkit.getVersion());
        if (matcher.find()) {
            int mcMajorVersion = ACFUtil.parseInt(matcher.toMatchResult().group(1), 0);
            int mcMinorVersion = ACFUtil.parseInt(matcher.toMatchResult().group(2), 0);
            manager.log(LogLevel.INFO, "Minecraft Version: " + mcMajorVersion + "." + mcMinorVersion);
            if (mcMajorVersion >= 1 && mcMinorVersion >= 12) {
                BukkitCommandContexts_1_12.register(this);
            }
        }
    }

    @Nullable
    OnlinePlayer getOnlinePlayer(BukkitCommandIssuer issuer, String lookup, boolean allowMissing) throws InvalidCommandArgument {
        Player player = ACFBukkitUtil.findPlayerSmart(issuer, lookup);
        if (player == null) {
            if (allowMissing) {
                return null;
            }
            throw new InvalidCommandArgument(false);
        }
        return new OnlinePlayer(player);
    }
}

