/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandHelp;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.ExceptionHandler;
import co.aikar.commands.ForwardingCommand;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MessageType;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.UnstableAPI;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.HelpCommand;
import co.aikar.commands.annotation.PreCommand;
import co.aikar.commands.annotation.Subcommand;
import co.aikar.commands.annotation.UnknownHandler;
import co.aikar.commands.apachecommonslang.ApacheCommonsLangUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseCommand {
    public static final String UNKNOWN = "__unknown";
    public static final String DEFAULT = "__default";
    final SetMultimap<String, RegisteredCommand> subCommands = HashMultimap.create();
    private Method preCommandHandler;
    private String execLabel;
    private String execSubcommand;
    private String[] origArgs;
    CommandManager<?, ?, ?> manager = null;
    BaseCommand parentCommand;
    Map<String, RootCommand> registeredCommands = new HashMap<String, RootCommand>();
    String description;
    String commandName;
    String usageMessage;
    String permission;
    private ExceptionHandler exceptionHandler = null;
    CommandOperationContext lastCommandOperationContext;

    public BaseCommand() {
    }

    public BaseCommand(String cmd) {
        this.commandName = cmd;
    }

    public String getExecCommandLabel() {
        return this.execLabel;
    }

    public String getExecSubcommand() {
        return this.execSubcommand;
    }

    public String[] getOrigArgs() {
        return this.origArgs;
    }

    void setParentCommand(BaseCommand command) {
        this.parentCommand = command;
    }

    void onRegister(CommandManager manager) {
        this.onRegister(manager, this.commandName);
    }

    void onRegister(CommandManager manager, String cmd) {
        String rootCmdAlias;
        this.manager = manager;
        Class<?> self = this.getClass();
        CommandAlias rootCmdAliasAnno = self.getAnnotation(CommandAlias.class);
        String string = rootCmdAlias = rootCmdAliasAnno != null ? manager.getCommandReplacements().replace(rootCmdAliasAnno.value()).toLowerCase() : null;
        if (cmd == null && rootCmdAlias != null) {
            cmd = ACFPatterns.PIPE.split(rootCmdAlias)[0];
        }
        this.commandName = cmd != null ? cmd : self.getSimpleName().toLowerCase();
        this.description = this.commandName + " commands";
        this.usageMessage = "/" + this.commandName;
        CommandPermission perm = self.getAnnotation(CommandPermission.class);
        if (perm != null) {
            this.permission = manager.getCommandReplacements().replace(perm.value());
        }
        boolean foundDefault = false;
        boolean foundUnknown = false;
        for (Method method : self.getDeclaredMethods()) {
            method.setAccessible(true);
            String sublist = null;
            String sub = this.getSubcommandValue(method);
            Default def = method.getAnnotation(Default.class);
            HelpCommand helpCommand = method.getAnnotation(HelpCommand.class);
            CommandAlias commandAliases = method.getAnnotation(CommandAlias.class);
            if (def != null || !foundDefault && helpCommand != null) {
                if (!foundDefault) {
                    this.registerSubcommand(method, DEFAULT);
                    if (def != null) {
                        foundDefault = true;
                    }
                } else {
                    ACFUtil.sneaky(new IllegalStateException("Multiple @Default/@HelpCommand commands, duplicate on " + method.getDeclaringClass().getName() + "#" + method.getName()));
                }
            }
            if (sub != null) {
                sublist = sub;
            } else if (commandAliases != null) {
                sublist = commandAliases.value();
            } else if (helpCommand != null) {
                sublist = helpCommand.value();
            }
            UnknownHandler unknown = method.getAnnotation(UnknownHandler.class);
            PreCommand preCommand = method.getAnnotation(PreCommand.class);
            if (unknown != null || !foundUnknown && helpCommand != null) {
                if (!foundUnknown) {
                    this.registerSubcommand(method, UNKNOWN);
                    if (unknown != null) {
                        foundUnknown = true;
                    }
                } else {
                    ACFUtil.sneaky(new IllegalStateException("Multiple @UnknownHandler/@HelpCommand commands, duplicate on " + method.getDeclaringClass().getName() + "#" + method.getName()));
                }
            } else if (preCommand != null) {
                if (this.preCommandHandler == null) {
                    this.preCommandHandler = method;
                } else {
                    ACFUtil.sneaky(new IllegalStateException("Multiple @PreCommand commands, duplicate on " + method.getDeclaringClass().getName() + "#" + method.getName()));
                }
            }
            if (sublist == null) continue;
            this.registerSubcommand(method, sublist);
        }
        if (rootCmdAlias != null) {
            HashSet cmdList = new HashSet();
            Collections.addAll(cmdList, ACFPatterns.PIPE.split(rootCmdAlias));
            cmdList.remove(cmd);
            for (String cmdAlias : cmdList) {
                this.register(cmdAlias, this);
            }
        }
        if (cmd != null) {
            this.register(cmd, this);
        }
        for (GenericDeclaration genericDeclaration : this.getClass().getDeclaredClasses()) {
            if (!BaseCommand.class.isAssignableFrom((Class<?>)genericDeclaration)) continue;
            try {
                Constructor<?>[] declaredConstructors;
                BaseCommand subCommand = null;
                for (Constructor<?> declaredConstructor : declaredConstructors = ((Class)genericDeclaration).getDeclaredConstructors()) {
                    declaredConstructor.setAccessible(true);
                    Parameter[] parameters = declaredConstructor.getParameters();
                    if (parameters.length == 1) {
                        subCommand = (BaseCommand)declaredConstructor.newInstance(this);
                        continue;
                    }
                    manager.log(LogLevel.INFO, "Found unusable constructor: " + declaredConstructor.getName() + "(" + Stream.of(parameters).map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.joining("<c2>,</c2> ")) + ")");
                }
                if (subCommand != null) {
                    subCommand.setParentCommand(this);
                    subCommand.onRegister(manager, cmd);
                    this.subCommands.putAll(subCommand.subCommands);
                    this.registeredCommands.putAll(subCommand.registeredCommands);
                    continue;
                }
                this.manager.log(LogLevel.ERROR, "Could not find a subcommand ctor for " + ((Class)genericDeclaration).getName());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private String getSubcommandValue(Method method) {
        Subcommand sub = method.getAnnotation(Subcommand.class);
        if (sub == null) {
            return null;
        }
        ArrayList<String> subList = new ArrayList<String>();
        subList.add(sub.value());
        for (Class<?> clazz = method.getDeclaringClass(); clazz != null; clazz = clazz.getEnclosingClass()) {
            Subcommand classSub = clazz.getAnnotation(Subcommand.class);
            if (classSub == null) continue;
            subList.add(classSub.value());
        }
        Collections.reverse(subList);
        return ACFUtil.join(subList, " ");
    }

    private void register(String name, BaseCommand cmd) {
        String nameLower = name.toLowerCase();
        RootCommand rootCommand = this.manager.obtainRootCommand(nameLower);
        rootCommand.addChild(cmd);
        this.registeredCommands.put(nameLower, rootCommand);
    }

    private void registerSubcommand(Method method, String subCommand) {
        subCommand = this.manager.getCommandReplacements().replace(subCommand.toLowerCase());
        Object[] subCommandParts = ACFPatterns.SPACE.split(subCommand);
        Set<String> cmdList = BaseCommand.getSubCommandPossibilityList((String[])subCommandParts);
        for (int i = 0; i < subCommandParts.length; ++i) {
            subCommandParts[i] = ACFPatterns.PIPE.split((CharSequence)subCommandParts[i])[0];
        }
        String prefSubCommand = ApacheCommonsLangUtil.join(subCommandParts, " ");
        CommandAlias cmdAlias = method.getAnnotation(CommandAlias.class);
        String[] aliasNames = cmdAlias != null ? ACFPatterns.PIPE.split(this.manager.getCommandReplacements().replace(cmdAlias.value().toLowerCase())) : null;
        void cmdName = aliasNames != null ? aliasNames[0] : this.commandName + " ";
        RegisteredCommand cmd = this.manager.createRegisteredCommand(this, (String)cmdName, method, prefSubCommand);
        for (String subcmd : cmdList) {
            this.subCommands.put((Object)subcmd, (Object)cmd);
        }
        cmd.addSubcommands(cmdList);
        if (aliasNames != null) {
            for (String name : aliasNames) {
                this.register(name, new ForwardingCommand(this, (String[])subCommandParts));
            }
        }
    }

    private static Set<String> getSubCommandPossibilityList(String[] subCommandParts) {
        HashSet<String> newList;
        int i = 0;
        HashSet<String> current = null;
        while (true) {
            newList = new HashSet<String>();
            if (i < subCommandParts.length) {
                for (String s1 : ACFPatterns.PIPE.split(subCommandParts[i])) {
                    if (current != null) {
                        newList.addAll(current.stream().map(s -> s + " " + s1).collect(Collectors.toList()));
                        continue;
                    }
                    newList.add(s1);
                }
            }
            if (i + 1 >= subCommandParts.length) break;
            current = newList;
            ++i;
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandIssuer issuer, String commandLabel, String[] args) {
        commandLabel = commandLabel.toLowerCase();
        try {
            CommandSearch cmd;
            CommandOperationContext commandContext = this.preCommandOperation(issuer, commandLabel, args);
            if (args.length > 0 && (cmd = this.findSubCommand(args)) != null) {
                this.execSubcommand = cmd.getCheckSub();
                String[] execargs = Arrays.copyOfRange(args, cmd.argIndex, args.length);
                this.executeCommand(commandContext, issuer, execargs, cmd.cmd);
                return;
            }
            if (this.subCommands.get((Object)DEFAULT) != null && args.length == 0) {
                this.executeSubcommand(commandContext, DEFAULT, issuer, args);
            } else if (this.subCommands.get((Object)UNKNOWN) != null) {
                if (!this.executeSubcommand(commandContext, UNKNOWN, issuer, args)) {
                    this.help(issuer, args);
                }
            } else if (this.subCommands.get((Object)DEFAULT) != null) {
                this.executeSubcommand(commandContext, DEFAULT, issuer, args);
            }
        }
        finally {
            this.postCommandOperation();
        }
    }

    private void postCommandOperation() {
        CommandManager.commandOperationContext.get().pop();
        this.execSubcommand = null;
        this.execLabel = null;
        this.origArgs = new String[0];
    }

    private CommandOperationContext preCommandOperation(CommandIssuer issuer, String commandLabel, String[] args) {
        Stack<CommandOperationContext> contexts = CommandManager.commandOperationContext.get();
        CommandOperationContext context = this.manager.createCommandOperationContext(this, issuer, commandLabel, args);
        contexts.push(context);
        this.lastCommandOperationContext = context;
        this.execSubcommand = null;
        this.execLabel = commandLabel;
        this.origArgs = args;
        return context;
    }

    public CommandIssuer getCurrentCommandIssuer() {
        return CommandManager.getCurrentCommandIssuer();
    }

    public CommandManager getCurrentCommandManager() {
        return CommandManager.getCurrentCommandManager();
    }

    private CommandSearch findSubCommand(String[] args) {
        return this.findSubCommand(args, false);
    }

    private CommandSearch findSubCommand(String[] args, boolean completion) {
        for (int i = args.length; i >= 0; --i) {
            String checkSub = ApacheCommonsLangUtil.join((Object[])args, " ", 0, i).toLowerCase();
            Set cmds = this.subCommands.get((Object)checkSub);
            int extraArgs = args.length - i;
            if (cmds.isEmpty()) continue;
            RegisteredCommand cmd = null;
            if (cmds.size() == 1) {
                cmd = (RegisteredCommand)Iterables.getOnlyElement((Iterable)cmds);
            } else {
                Optional<RegisteredCommand> optCmd = cmds.stream().filter(c -> {
                    int required = c.requiredResolvers;
                    int optional = c.optionalResolvers;
                    return extraArgs <= required + optional && (completion || extraArgs >= required);
                }).sorted((c1, c2) -> {
                    int a = c1.requiredResolvers + c1.optionalResolvers;
                    int b = c2.requiredResolvers + c2.optionalResolvers;
                    if (a == b) {
                        return 0;
                    }
                    return a < b ? 1 : -1;
                }).findFirst();
                if (optCmd.isPresent()) {
                    cmd = optCmd.get();
                }
            }
            if (cmd == null) continue;
            return new CommandSearch(cmd, i, checkSub);
        }
        return null;
    }

    private void executeCommand(CommandOperationContext commandOperationContext, CommandIssuer issuer, String[] args, RegisteredCommand cmd) {
        if (cmd.hasPermission(issuer)) {
            commandOperationContext.setRegisteredCommand(cmd);
            if (this.checkPrecommand(commandOperationContext, cmd, issuer, args)) {
                return;
            }
            ArrayList sargs = Lists.newArrayList((Object[])args);
            cmd.invoke(issuer, sargs);
        } else {
            issuer.sendMessage(MessageType.ERROR, MessageKeys.PERMISSION_DENIED, new String[0]);
        }
    }

    public boolean canExecute(CommandIssuer issuer, RegisteredCommand<?> cmd) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> tabComplete(CommandIssuer issuer, String commandLabel, String[] args) throws IllegalArgumentException {
        commandLabel = commandLabel.toLowerCase();
        try {
            CommandOperationContext commandOperationContext = this.preCommandOperation(issuer, commandLabel, args);
            CommandSearch search = this.findSubCommand(args, true);
            String argString = ApacheCommonsLangUtil.join((Object[])args, " ").toLowerCase();
            ArrayList<String> cmds = new ArrayList<String>();
            if (search != null) {
                cmds.addAll(this.completeCommand(commandOperationContext, issuer, search.cmd, Arrays.copyOfRange(args, search.argIndex, args.length), commandLabel));
            } else if (this.subCommands.get((Object)UNKNOWN).size() == 1) {
                cmds.addAll(this.completeCommand(commandOperationContext, issuer, (RegisteredCommand)Iterables.getOnlyElement((Iterable)this.subCommands.get((Object)UNKNOWN)), args, commandLabel));
            }
            for (Map.Entry entry : this.subCommands.entries()) {
                RegisteredCommand value;
                String key = (String)entry.getKey();
                if (!key.startsWith(argString) || UNKNOWN.equals(key) || DEFAULT.equals(key) || !(value = (RegisteredCommand)entry.getValue()).hasPermission(issuer)) continue;
                String prefCommand = value.prefSubCommand;
                String[] psplit = ACFPatterns.SPACE.split(prefCommand);
                cmds.add(psplit[args.length - 1]);
            }
            List<String> list = BaseCommand.filterTabComplete(args[args.length - 1], cmds);
            return list;
        }
        finally {
            this.postCommandOperation();
        }
    }

    private List<String> completeCommand(CommandOperationContext commandOperationContext, CommandIssuer issuer, RegisteredCommand cmd, String[] args, String commandLabel) {
        if (!cmd.hasPermission(issuer) || args.length > cmd.requiredResolvers + cmd.optionalResolvers || args.length == 0 || cmd.complete == null) {
            return ImmutableList.of();
        }
        String[] completions = ACFPatterns.SPACE.split(cmd.complete);
        List<String> cmds = this.manager.getCommandCompletions().of(commandOperationContext, cmd, issuer, completions, args);
        return BaseCommand.filterTabComplete(args[args.length - 1], cmds);
    }

    private static List<String> filterTabComplete(String arg, List<String> cmds) {
        return cmds.stream().distinct().filter(cmd -> cmd != null && (arg.isEmpty() || ApacheCommonsLangUtil.startsWithIgnoreCase(cmd, arg))).collect(Collectors.toList());
    }

    RegisteredCommand getSubcommand(String subcommand) {
        return this.getSubcommand(subcommand, false);
    }

    RegisteredCommand getSubcommand(String subcommand, boolean requireOne) {
        Set commands = this.subCommands.get((Object)subcommand);
        if (!(commands.isEmpty() || requireOne && commands.size() != 1)) {
            return (RegisteredCommand)commands.iterator().next();
        }
        return null;
    }

    private boolean executeSubcommand(CommandOperationContext commandContext, String subcommand, CommandIssuer issuer, String ... args) {
        RegisteredCommand cmd = this.getSubcommand(subcommand);
        if (cmd != null) {
            this.executeCommand(commandContext, issuer, args, cmd);
            return true;
        }
        return false;
    }

    private boolean checkPrecommand(CommandOperationContext commandOperationContext, RegisteredCommand cmd, CommandIssuer issuer, String[] args) {
        Method pre = this.preCommandHandler;
        if (pre != null) {
            try {
                Class<?>[] types = pre.getParameterTypes();
                Object[] parameters = new Object[pre.getParameterCount()];
                for (int i = 0; i < parameters.length; ++i) {
                    Class<?> type = types[i];
                    Object issuerObject = issuer.getIssuer();
                    parameters[i] = this.manager.isCommandIssuer(type) && type.isAssignableFrom(issuerObject.getClass()) ? issuerObject : (CommandIssuer.class.isAssignableFrom(type) ? issuer : (RegisteredCommand.class.isAssignableFrom(type) ? cmd : (String[].class.isAssignableFrom(type) ? args : null)));
                }
                return (Boolean)pre.invoke((Object)this, parameters);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.manager.log(LogLevel.ERROR, "Exception encountered while command pre-processing", e);
            }
        }
        return false;
    }

    @Deprecated
    @UnstableAPI
    public CommandHelp getCommandHelp() {
        return this.manager.generateCommandHelp();
    }

    @Deprecated
    @UnstableAPI
    public void showCommandHelp() {
        this.getCommandHelp().showHelp();
    }

    public void help(Object issuer, String[] args) {
        this.help(this.manager.getCommandIssuer(issuer), args);
    }

    public void help(CommandIssuer issuer, String[] args) {
        issuer.sendMessage(MessageType.ERROR, MessageKeys.UNKNOWN_COMMAND, new String[0]);
    }

    public void doHelp(Object issuer, String ... args) {
        this.doHelp(this.manager.getCommandIssuer(issuer), args);
    }

    public void doHelp(CommandIssuer issuer, String ... args) {
        this.help(issuer, args);
    }

    public void showSyntax(CommandIssuer issuer, RegisteredCommand<?> cmd) {
        issuer.sendMessage(MessageType.SYNTAX, MessageKeys.INVALID_SYNTAX, "{command}", "/" + cmd.command, "{syntax}", cmd.syntaxText);
    }

    public boolean hasPermission(Object issuer) {
        return this.hasPermission(this.manager.getCommandIssuer(issuer));
    }

    public boolean hasPermission(CommandIssuer issuer) {
        return this.permission == null || this.permission.isEmpty() || this.manager.hasPermission(issuer, this.permission) && (this.parentCommand == null || this.parentCommand.hasPermission(issuer));
    }

    public String getName() {
        return this.commandName;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public BaseCommand setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public RegisteredCommand getDefaultRegisteredCommand() {
        return this.getSubcommand(DEFAULT);
    }

    private static class CommandSearch {
        RegisteredCommand cmd;
        int argIndex;
        String checkSub;

        CommandSearch(RegisteredCommand cmd, int argIndex, String checkSub) {
            this.cmd = cmd;
            this.argIndex = argIndex;
            this.checkSub = checkSub;
        }

        String getCheckSub() {
            return this.checkSub;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandSearch that = (CommandSearch)o;
            return this.argIndex == that.argIndex && Objects.equals(this.cmd, that.cmd) && Objects.equals(this.checkSub, that.checkSub);
        }

        public int hashCode() {
            return Objects.hash(this.cmd, this.argIndex, this.checkSub);
        }
    }
}

