/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandHelp;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.annotation.Single;
import co.aikar.commands.annotation.Split;
import co.aikar.commands.annotation.Values;
import co.aikar.commands.contexts.ContextResolver;
import co.aikar.commands.contexts.IssuerAwareContextResolver;
import co.aikar.commands.contexts.IssuerOnlyContextResolver;
import co.aikar.commands.contexts.OptionalContextResolver;
import co.aikar.locales.MessageKeyProvider;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class CommandContexts<R extends CommandExecutionContext<?, ? extends CommandIssuer>> {
    protected final Map<Class<?>, ContextResolver<?, R>> contextMap = Maps.newHashMap();
    protected final CommandManager manager;

    CommandContexts(CommandManager manager) {
        this.manager = manager;
        this.registerContext(Integer.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).intValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, new String[0]);
            }
        });
        this.registerContext(Long.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).longValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, new String[0]);
            }
        });
        this.registerContext(Float.class, c -> {
            try {
                return Float.valueOf(ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).floatValue());
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, new String[0]);
            }
        });
        this.registerContext(Double.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).doubleValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, new String[0]);
            }
        });
        this.registerContext(Number.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes"));
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_A_NUMBER, new String[0]);
            }
        });
        this.registerContext(Boolean.class, c -> {
            String test = c.popFirstArg();
            if (test == null) {
                return null;
            }
            return ACFUtil.isTruthy(test);
        });
        this.registerContext(String.class, c -> {
            Values values = c.getParam().getAnnotation(Values.class);
            if (values != null) {
                return c.popFirstArg();
            }
            String ret = c.isLastArg() && c.getParam().getAnnotation(Single.class) == null ? ACFUtil.join(c.getArgs()) : c.popFirstArg();
            Integer minLen = c.getFlagValue("minlen", (Integer)null);
            Integer maxLen = c.getFlagValue("maxlen", (Integer)null);
            if (minLen != null && ret.length() < minLen) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_MIN_LENGTH, "{min}", String.valueOf(minLen));
            }
            if (maxLen != null && ret.length() > maxLen) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.MUST_BE_MAX_LENGTH, "{max}", String.valueOf(maxLen));
            }
            return ret;
        });
        this.registerContext(String[].class, c -> {
            List<String> args = c.getArgs();
            String val = c.isLastArg() && c.getParam().getAnnotation(Single.class) == null ? ACFUtil.join(args) : c.popFirstArg();
            Split split = c.getParam().getAnnotation(Split.class);
            if (split != null) {
                if (val.isEmpty()) {
                    throw new InvalidCommandArgument();
                }
                return ACFPatterns.getPattern(split.value()).split(val);
            }
            if (!c.isLastArg()) {
                ACFUtil.sneaky(new IllegalStateException("Weird Command signature... String[] should be last or @Split"));
            }
            String[] result = args.toArray(new String[args.size()]);
            args.clear();
            return result;
        });
        this.registerContext(Enum.class, c -> {
            String first = c.popFirstArg();
            Class<?> enumCls = c.getParam().getType();
            Object match = ACFUtil.simpleMatch(enumCls, first);
            if (match == null) {
                List<String> names = ACFUtil.enumNames(enumCls);
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", ACFUtil.join(names));
            }
            return match;
        });
        this.registerOptionalContext(CommandHelp.class, c -> {
            String first = c.getFirstArg();
            String last = c.getLastArg();
            int page = 1;
            List<String> search = null;
            if (last != null && ACFUtil.isInteger(last)) {
                c.popLastArg();
                page = ACFUtil.parseInt(last);
                if (!c.getArgs().isEmpty()) {
                    search = c.getArgs();
                }
            } else if (first != null && ACFUtil.isInteger(first)) {
                c.popFirstArg();
                page = ACFUtil.parseInt(first);
                if (!c.getArgs().isEmpty()) {
                    search = c.getArgs();
                }
            } else if (!c.getArgs().isEmpty()) {
                search = c.getArgs();
            }
            CommandHelp commandHelp = manager.generateCommandHelp();
            commandHelp.setPage(page);
            commandHelp.setSearch(search);
            return commandHelp;
        });
    }

    @Deprecated
    public <T> void registerSenderAwareContext(Class<T> context, IssuerAwareContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerIssuerAwareContext(Class<T> context, IssuerAwareContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerIssuerOnlyContext(Class<T> context, IssuerOnlyContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerOptionalContext(Class<T> context, OptionalContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerContext(Class<T> context, ContextResolver<T, R> supplier) {
        this.contextMap.put(context, supplier);
    }

    public ContextResolver<?, R> getResolver(Class<?> type) {
        Class<?> rootType = type;
        while (type != Object.class) {
            ContextResolver<?, R> resolver = this.contextMap.get(type);
            if (resolver != null) {
                return resolver;
            }
            if ((type = type.getSuperclass()) != null) continue;
        }
        this.manager.log(LogLevel.ERROR, "Could not find context resolver", new IllegalStateException("No context resolver defined for " + rootType.getName()));
        return null;
    }
}

