/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.HelpEntry;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MessageType;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.locales.MessageKeyProvider;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CommandHelp {
    private final CommandManager manager;
    private final CommandIssuer issuer;
    private final List<HelpEntry> helpEntries = new ArrayList<HelpEntry>();

    public CommandHelp(CommandManager manager, RootCommand rootCommand, CommandIssuer issuer) {
        this.manager = manager;
        this.issuer = issuer;
        SetMultimap<String, RegisteredCommand> subCommands = rootCommand.getSubCommands();
        HashSet seen = new HashSet();
        subCommands.entries().forEach(e -> {
            String key = (String)e.getKey();
            if (key.equals("__default") || key.equals("__unknown")) {
                return;
            }
            RegisteredCommand regCommand = (RegisteredCommand)e.getValue();
            if (regCommand.hasPermission(issuer) && !seen.contains(regCommand)) {
                this.helpEntries.add(new HelpEntry(regCommand));
                seen.add(regCommand);
            }
        });
    }

    public CommandManager getManager() {
        return this.manager;
    }

    public void showHelp() {
        this.showHelp(this.issuer, MessageKeys.HELP_FORMAT);
    }

    public void showHelp(CommandIssuer issuer) {
        this.showHelp(issuer, MessageKeys.HELP_FORMAT);
    }

    public void showHelp(CommandIssuer issuer, MessageKeyProvider format) {
        this.getHelpEntries().forEach(e -> {
            String formatted = this.manager.formatMessage(issuer, MessageType.HELP, format, this.getFormatReplacements((HelpEntry)e));
            for (String msg : ACFPatterns.NEWLINE.split(formatted)) {
                issuer.sendMessageInternal(ACFUtil.rtrim(msg));
            }
        });
    }

    @NotNull
    public String[] getFormatReplacements(HelpEntry e) {
        return new String[]{"{command}", e.getCommand(), "{parameters}", e.getParameterSyntax(), "{seperator}", e.getDescription().isEmpty() ? "" : "-", "{description}", e.getDescription()};
    }

    public List<HelpEntry> getHelpEntries() {
        return this.helpEntries;
    }
}

