/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;

public abstract class MessageFormatter<C> {
    private final List<C> colors = new ArrayList<C>();

    @SafeVarargs
    public MessageFormatter(C ... colors) {
        this.colors.addAll(Arrays.asList(colors));
    }

    public C setColor(int index, C color) {
        index = index > 0 ? --index : 0;
        if (this.colors.size() <= index) {
            int needed = index - this.colors.size();
            if (needed > 0) {
                this.colors.addAll(Collections.nCopies(needed, null));
            }
            this.colors.add(color);
            return null;
        }
        return this.colors.set(index, color);
    }

    public C getColor(int index) {
        index = index > 0 ? --index : 0;
        C color = this.colors.get(index);
        if (color == null) {
            color = this.getDefaultColor();
        }
        return color;
    }

    public C getDefaultColor() {
        return this.getColor(1);
    }

    abstract String format(C var1, String var2);

    public String format(int index, String message) {
        return this.format(this.getColor(index), message);
    }

    public String format(String message) {
        String def = this.format(1, "");
        Matcher matcher = ACFPatterns.FORMATTER.matcher(message);
        StringBuffer sb = new StringBuffer(message.length());
        while (matcher.find()) {
            Integer color = ACFUtil.parseInt(matcher.group("color"), 1);
            String msg = this.format(color, matcher.group("msg")) + def;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(msg));
        }
        matcher.appendTail(sb);
        return def + sb.toString();
    }
}

