/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import co.aikar.locales.LocaleManager;
import co.aikar.locales.MessageKey;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class Locales {
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale SPANISH = new Locale("es");
    public static final Locale DUTCH = new Locale("nl");
    public static final Locale DANISH = new Locale("da");
    public static final Locale CZECH = new Locale("cs");
    public static final Locale GREEK = new Locale("el");
    public static final Locale LATIN = new Locale("la");
    public static final Locale BULGARIAN = new Locale("bg");
    public static final Locale AFRIKAANS = new Locale("af");
    public static final Locale HINDI = new Locale("hi");
    public static final Locale HEBREW = new Locale("he");
    public static final Locale POLISH = new Locale("pl");
    public static final Locale PORTUGUESE = new Locale("pt");
    public static final Locale FINNISH = new Locale("fi");
    public static final Locale SWEDISH = new Locale("sv");
    public static final Locale RUSSIAN = new Locale("ru");
    public static final Locale ROMANIAN = new Locale("ro");
    public static final Locale VIETNAMESE = new Locale("vi");
    public static final Locale THAI = new Locale("th");
    public static final Locale TURKISH = new Locale("tr");
    public static final Locale UKRANIAN = new Locale("uk");
    public static final Locale ARABIC = new Locale("ar");
    public static final Locale WELSH = new Locale("cy");
    private final CommandManager<?, ?, ?> manager;
    private final LocaleManager<CommandIssuer> localeManager;
    private final SetMultimap<String, Locale> loadedBundles = HashMultimap.create();

    public Locales(CommandManager manager) {
        this.manager = manager;
        this.localeManager = LocaleManager.create(manager::getIssuerLocale);
    }

    public void loadLanguages() {
        this.addMessageBundles("acf-core");
    }

    public Locale getDefaultLocale() {
        return this.localeManager.getDefaultLocale();
    }

    public Locale setDefaultLocale(Locale locale) {
        return this.localeManager.setDefaultLocale(locale);
    }

    public void loadMissingBundles() {
        for (Locale locale : this.manager.getSupportedLanguages()) {
            for (String bundleName : this.loadedBundles.keys()) {
                this.addMessageBundle(bundleName, locale);
            }
        }
    }

    public void addMessageBundles(String ... bundleNames) {
        for (String bundleName : bundleNames) {
            for (Locale locale : this.manager.getSupportedLanguages()) {
                this.addMessageBundle(bundleName, locale);
            }
        }
    }

    public void addMessageBundle(String bundleName, Locale locale) {
        if (!this.loadedBundles.containsEntry((Object)bundleName, (Object)locale)) {
            this.loadedBundles.put((Object)bundleName, (Object)locale);
            this.localeManager.addMessageBundle(bundleName, locale);
        }
    }

    public void addMessageStrings(Locale locale, @NotNull Map<String, String> messages) {
        HashMap<MessageKey, String> map = new HashMap<MessageKey, String>(messages.size());
        messages.forEach((key, value) -> map.put(MessageKey.of(key), (String)value));
        this.addMessages(locale, map);
    }

    public void addMessages(Locale locale, @NotNull Map<MessageKey, String> messages) {
        this.localeManager.addMessages(locale, messages);
    }

    public String addMessage(Locale locale, MessageKey key, String message) {
        return this.localeManager.addMessage(locale, key, message);
    }

    public String getMessage(CommandIssuer issuer, MessageKey key) {
        String message = this.localeManager.getMessage(issuer, key);
        if (message == null) {
            this.manager.log(LogLevel.ERROR, "Missing Language Key: " + key.getKey());
            message = "<MISSING_LANGUAGE_KEY:" + key.getKey() + ">";
        }
        return message;
    }

    public String replaceI18NStrings(String message) {
        if (message == null) {
            return null;
        }
        Matcher matcher = ACFPatterns.I18N_STRING.matcher(message);
        if (!matcher.matches()) {
            return message;
        }
        CommandIssuer issuer = CommandManager.getCurrentCommandIssuer();
        matcher.reset();
        StringBuffer sb = new StringBuffer(message.length());
        while (matcher.find()) {
            MessageKey key = MessageKey.of(matcher.group("key"));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.getMessage(issuer, key)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

