/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import co.aikar.locales.LocaleManager;
import co.aikar.locales.MessageKey;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class Locales {
    private final CommandManager<?, ?, ?> manager;
    private final LocaleManager<CommandIssuer> localeManager;
    private final SetMultimap<String, Locale> loadedBundles = HashMultimap.create();

    public Locales(CommandManager manager) {
        this.manager = manager;
        this.localeManager = LocaleManager.create(manager::getIssuerLocale);
    }

    public void loadLanguages() {
        this.addMessageBundles("acf-core");
    }

    public Locale getDefaultLocale() {
        return this.localeManager.getDefaultLocale();
    }

    public Locale setDefaultLocale(Locale locale) {
        return this.localeManager.setDefaultLocale(locale);
    }

    public void loadMissingBundles() {
        for (Locale locale : this.manager.getSupportedLanguages()) {
            for (String bundleName : this.loadedBundles.keys()) {
                this.addMessageBundle(bundleName, locale);
            }
        }
    }

    public void addMessageBundles(String ... bundleNames) {
        for (String bundleName : bundleNames) {
            for (Locale locale : this.manager.getSupportedLanguages()) {
                this.addMessageBundle(bundleName, locale);
            }
        }
    }

    public void addMessageBundle(String bundleName, Locale locale) {
        if (!this.loadedBundles.containsEntry((Object)bundleName, (Object)locale)) {
            this.loadedBundles.put((Object)bundleName, (Object)locale);
            this.localeManager.addMessageBundle(bundleName, locale);
        }
    }

    public void addMessageStrings(Locale locale, @NotNull Map<String, String> messages) {
        HashMap<MessageKey, String> map = new HashMap<MessageKey, String>(messages.size());
        messages.forEach((key, value) -> map.put(MessageKey.of(key), (String)value));
        this.addMessages(locale, map);
    }

    public void addMessages(Locale locale, @NotNull Map<MessageKey, String> messages) {
        this.localeManager.addMessages(locale, messages);
    }

    public String addMessage(Locale locale, MessageKey key, String message) {
        return this.localeManager.addMessage(locale, key, message);
    }

    public String getMessage(CommandIssuer issuer, MessageKey key) {
        String message = this.localeManager.getMessage(issuer, key);
        if (message == null) {
            this.manager.log(LogLevel.ERROR, "Missing Language Key: " + key.getKey());
            message = "<MISSING_LANGUAGE_KEY:" + key.getKey() + ">";
        }
        return message;
    }

    public String replaceI18NStrings(String message) {
        if (message == null) {
            return null;
        }
        Matcher matcher = ACFPatterns.I18N_STRING.matcher(message);
        if (!matcher.matches()) {
            return message;
        }
        CommandIssuer issuer = CommandManager.getCurrentCommandIssuer();
        matcher.reset();
        StringBuffer sb = new StringBuffer(message.length());
        while (matcher.find()) {
            MessageKey key = MessageKey.of(matcher.group("key"));
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.getMessage(issuer, key)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

