/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.CommandReplacements;
import co.aikar.commands.ExceptionHandler;
import co.aikar.commands.Locales;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageFormatter;
import co.aikar.commands.MessageType;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.locales.MessageKeyProvider;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class CommandManager<I, FT, F extends MessageFormatter<FT>> {
    static ThreadLocal<Stack<CommandOperationContext>> commandOperationContext = ThreadLocal.withInitial(() -> new Stack<CommandOperationContext>(){

        @Override
        public synchronized CommandOperationContext peek() {
            return super.size() == 0 ? null : (CommandOperationContext)super.peek();
        }
    });
    protected Map<String, RootCommand> rootCommands = new HashMap<String, RootCommand>();
    protected CommandReplacements replacements = new CommandReplacements(this);
    protected ExceptionHandler defaultExceptionHandler = null;
    protected Set<Locale> supportedLanguages = Sets.newHashSet((Object[])new Locale[]{Locale.ENGLISH});
    protected Map<MessageType, F> formatters = new IdentityHashMap<MessageType, F>();
    protected F defaultFormatter;

    public static CommandOperationContext getCurrentCommandOperationContext() {
        return commandOperationContext.get().peek();
    }

    public static CommandIssuer getCurrentCommandIssuer() {
        CommandOperationContext context = commandOperationContext.get().peek();
        return context != null ? context.getCommandIssuer() : null;
    }

    public static CommandManager getCurrentCommandManager() {
        CommandOperationContext context = commandOperationContext.get().peek();
        return context != null ? context.getCommandManager() : null;
    }

    public F setFormat(MessageType type, F formatter) {
        return (F)((MessageFormatter)this.formatters.put(type, formatter));
    }

    public F getFormat(MessageType type) {
        return (F)((MessageFormatter)this.formatters.getOrDefault(type, this.defaultFormatter));
    }

    public void setFormat(MessageType type, FT ... colors) {
        F format = this.getFormat(type);
        for (int i = 0; i < colors.length; ++i) {
            ((MessageFormatter)format).setColor(i, colors[i]);
        }
    }

    public void setFormat(MessageType type, int i, FT color) {
        F format = this.getFormat(type);
        ((MessageFormatter)format).setColor(i, color);
    }

    public F getDefaultFormatter() {
        return this.defaultFormatter;
    }

    public void setDefaultFormatter(F defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    public abstract CommandContexts<?> getCommandContexts();

    public abstract CommandCompletions<?> getCommandCompletions();

    public abstract void registerCommand(BaseCommand var1);

    public abstract boolean hasRegisteredCommands();

    public abstract boolean isCommandIssuer(Class<?> var1);

    public abstract CommandIssuer getCommandIssuer(Object var1);

    public abstract RootCommand createRootCommand(String var1);

    public abstract Locales getLocales();

    public abstract <R extends CommandExecutionContext> R createCommandContext(RegisteredCommand var1, Parameter var2, CommandIssuer var3, List<String> var4, int var5, Map<String, Object> var6);

    public abstract CommandCompletionContext createCompletionContext(RegisteredCommand var1, CommandIssuer var2, String var3, String var4, String[] var5);

    public abstract void log(LogLevel var1, String var2, Throwable var3);

    public void log(LogLevel level, String message) {
        this.log(level, message, null);
    }

    public CommandReplacements getCommandReplacements() {
        return this.replacements;
    }

    public boolean hasPermission(CommandIssuer issuer, String permission) {
        return permission == null || permission.isEmpty() || issuer.hasPermission(permission);
    }

    public synchronized RootCommand obtainRootCommand(String cmd) {
        return this.rootCommands.computeIfAbsent(cmd.toLowerCase(), this::createRootCommand);
    }

    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new RegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    public void setDefaultExceptionHandler(ExceptionHandler exceptionHandler) {
        this.defaultExceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getDefaultExceptionHandler() {
        return this.defaultExceptionHandler;
    }

    protected boolean handleUncaughtException(BaseCommand scope, RegisteredCommand registeredCommand, CommandIssuer sender, List<String> args, Throwable t) {
        boolean result = false;
        if (scope.getExceptionHandler() != null) {
            result = scope.getExceptionHandler().execute(scope, registeredCommand, sender, args, t);
        } else if (this.defaultExceptionHandler != null) {
            result = this.defaultExceptionHandler.execute(scope, registeredCommand, sender, args, t);
        }
        return result;
    }

    public void sendMessage(I issuerArg, MessageType type, MessageKeyProvider key, String ... replacements) {
        this.sendMessage(this.getCommandIssuer(issuerArg), type, key, replacements);
    }

    public void sendMessage(CommandIssuer issuer, MessageType type, MessageKeyProvider key, String ... replacements) {
        String message = this.getLocales().getMessage(issuer, key.getMessageKey());
        if (replacements.length > 0) {
            message = ACFUtil.replaceStrings(message, replacements);
        }
        message = this.getCommandReplacements().replace(message);
        MessageFormatter formatter = (MessageFormatter)this.formatters.getOrDefault(type, this.defaultFormatter);
        if (formatter != null) {
            message = formatter.format(message);
        }
        for (String msg : ACFPatterns.NEWLINE.split(message)) {
            issuer.sendMessageInternal(msg);
        }
    }

    public Locale getIssuerLocale(CommandIssuer issuer) {
        return this.getLocales().getDefaultLocale();
    }

    public CommandOperationContext createCommandOperationContext(BaseCommand command, CommandIssuer issuer, String commandLabel, String[] args) {
        return new CommandOperationContext(this, issuer, command, commandLabel, args);
    }

    public Set<Locale> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void addSupportedLanguage(Locale locale) {
        this.supportedLanguages.add(locale);
        this.getLocales().loadMissingBundles();
    }
}

