/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.CommandReplacements;
import co.aikar.commands.ExceptionHandler;
import co.aikar.commands.Locales;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageFormatter;
import co.aikar.commands.MessageType;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.locales.MessageKey;
import co.aikar.locales.MessageKeyProvider;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class CommandManager {
    static ThreadLocal<Stack<CommandOperationContext>> commandOperationContext = ThreadLocal.withInitial(Stack::new);
    protected Map<String, RootCommand> rootCommands = new HashMap<String, RootCommand>();
    protected CommandReplacements replacements = new CommandReplacements(this);
    protected ExceptionHandler defaultExceptionHandler = null;
    protected Set<Locale> supportedLanguages = Sets.newHashSet((Object[])new Locale[]{Locale.ENGLISH});
    protected Map<MessageType, MessageFormatter> formatters = new IdentityHashMap<MessageType, MessageFormatter>();
    protected MessageFormatter defaultFormatter;

    public CommandManager() {
        MessageFormatter<Object> plain = new MessageFormatter<Object>(new Object[0]){

            @Override
            String format(Object color, String message) {
                return message;
            }
        };
        this.defaultFormatter = plain;
        this.formatters.put(MessageType.INFO, plain);
        this.formatters.put(MessageType.SYNTAX, plain);
        this.formatters.put(MessageType.ERROR, plain);
    }

    public static CommandOperationContext getCurrentCommandOperationContext() {
        return commandOperationContext.get().peek();
    }

    public static CommandIssuer getCurrentCommandIssuer() {
        CommandOperationContext context = commandOperationContext.get().peek();
        return context != null ? context.getCommandIssuer() : null;
    }

    public static CommandManager getCurrentCommandManager() {
        CommandOperationContext context = commandOperationContext.get().peek();
        return context != null ? context.getCommandManager() : null;
    }

    public abstract CommandContexts<?> getCommandContexts();

    public abstract CommandCompletions<?> getCommandCompletions();

    public abstract void registerCommand(BaseCommand var1);

    public abstract boolean hasRegisteredCommands();

    public abstract boolean isCommandIssuer(Class<?> var1);

    public abstract CommandIssuer getCommandIssuer(Object var1);

    public abstract RootCommand createRootCommand(String var1);

    public abstract Locales getLocales();

    public abstract <R extends CommandExecutionContext> R createCommandContext(RegisteredCommand var1, Parameter var2, CommandIssuer var3, List<String> var4, int var5, Map<String, Object> var6);

    public abstract CommandCompletionContext createCompletionContext(RegisteredCommand var1, CommandIssuer var2, String var3, String var4, String[] var5);

    public abstract void log(LogLevel var1, String var2, Throwable var3);

    public void log(LogLevel level, String message) {
        this.log(level, message, null);
    }

    public CommandReplacements getCommandReplacements() {
        return this.replacements;
    }

    public boolean hasPermission(CommandIssuer issuer, String permission) {
        return permission == null || permission.isEmpty() || issuer.hasPermission(permission);
    }

    public synchronized RootCommand obtainRootCommand(String cmd) {
        return this.rootCommands.computeIfAbsent(cmd.toLowerCase(), this::createRootCommand);
    }

    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new RegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    public void setDefaultExceptionHandler(ExceptionHandler exceptionHandler) {
        this.defaultExceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getDefaultExceptionHandler() {
        return this.defaultExceptionHandler;
    }

    protected boolean handleUncaughtException(BaseCommand scope, RegisteredCommand registeredCommand, CommandIssuer sender, List<String> args, Throwable t) {
        boolean result = false;
        if (scope.getExceptionHandler() != null) {
            result = scope.getExceptionHandler().execute(scope, registeredCommand, sender, args, t);
        } else if (this.defaultExceptionHandler != null) {
            result = this.defaultExceptionHandler.execute(scope, registeredCommand, sender, args, t);
        }
        return result;
    }

    public MessageFormatter setFormat(MessageType type, MessageFormatter formatter) {
        return this.formatters.put(type, formatter);
    }

    public MessageFormatter getFormat(MessageType type) {
        return this.formatters.get(type);
    }

    public MessageFormatter getDefaultFormatter() {
        return this.defaultFormatter;
    }

    public void setDefaultFormatter(MessageFormatter defaultFormatter) {
        this.defaultFormatter = defaultFormatter;
    }

    public void sendMessage(Object issuerArg, MessageType type, MessageKeyProvider key, String ... replacements) {
        this.sendMessage(issuerArg, type, key.getMessageKey(), replacements);
    }

    public void sendMessage(Object issuerArg, MessageType type, MessageKey key, String ... replacements) {
        MessageFormatter formatter;
        CommandIssuer issuer = issuerArg instanceof CommandIssuer ? (CommandIssuer)issuerArg : this.getCommandIssuer(issuerArg);
        String message = this.getLocales().getMessage(issuer, key);
        if (replacements.length > 0) {
            message = ACFUtil.replaceStrings(message, replacements);
        }
        if ((formatter = this.formatters.getOrDefault(type, this.defaultFormatter)) != null) {
            message = formatter.format(message);
        }
        for (String msg : ACFPatterns.NEWLINE.split(message)) {
            issuer.sendMessageInternal(msg);
        }
    }

    public Locale getIssuerLocale(CommandIssuer issuer) {
        return this.getLocales().getDefaultLocale();
    }

    public CommandOperationContext createCommandOperationContext(BaseCommand command, CommandIssuer issuer, String commandLabel, String[] args) {
        return new CommandOperationContext(this, issuer, command, commandLabel, args);
    }

    public Set<Locale> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void addSupportedLanguage(Locale locale) {
        this.supportedLanguages.add(locale);
        this.getLocales().loadMissingBundles();
    }
}

