/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.locales;

import co.aikar.locales.LanguageTable;
import co.aikar.locales.MessageKey;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class LocaleManager<T> {
    private static Pattern SPLIT_PATTERN = Pattern.compile("_");
    private final Class<?> classpathOwner;
    private final Function<T, Locale> localeMapper;
    private final Locale defaultLocale;
    private final Map<Locale, LanguageTable> tables = new HashMap<Locale, LanguageTable>();

    LocaleManager(Class<?> classpathOwner, Function<T, Locale> localeMapper, Locale defaultLocale) {
        this.classpathOwner = classpathOwner;
        this.localeMapper = localeMapper;
        this.defaultLocale = defaultLocale;
    }

    public static <T> LocaleManager<T> create(@NotNull Function<T, Locale> localeMapper) {
        return LocaleManager.create(localeMapper, Locale.ENGLISH);
    }

    public static <T> LocaleManager<T> create(@NotNull Function<T, Locale> localeMapper, Locale defaultLocale) {
        return LocaleManager.create(localeMapper.getClass(), localeMapper, defaultLocale);
    }

    public static <T> LocaleManager<T> create(Class<?> classpathOwner, @NotNull Function<T, Locale> localeMapper) {
        return new LocaleManager<T>(classpathOwner, localeMapper, Locale.ENGLISH);
    }

    public static <T> LocaleManager<T> create(Class<?> classpathOwner, @NotNull Function<T, Locale> localeMapper, Locale defaultLocale) {
        return new LocaleManager<T>(classpathOwner, localeMapper, defaultLocale);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public boolean addMessageBundle(@NotNull String bundleName, Locale ... locales) {
        if (locales.length == 0) {
            locales = new Locale[]{this.defaultLocale};
        }
        boolean found = false;
        for (Locale locale : locales) {
            if (!this.getTable(locale).addMessageBundle(bundleName)) continue;
            found = true;
        }
        return found;
    }

    public void addMessages(@NotNull Locale locale, @NotNull Map<MessageKey, String> messages) {
        this.getTable(locale).addMessages(messages);
    }

    public String addMessage(@NotNull Locale locale, @NotNull MessageKey key, @NotNull String message) {
        return this.getTable(locale).addMessage(key, message);
    }

    public String getMessage(T context, @NotNull MessageKey key) {
        Locale locale = this.localeMapper.apply(context);
        String message = this.getTable(locale).getMessage(key);
        if (message == null && !locale.getCountry().isEmpty()) {
            message = this.getTable(new Locale(locale.getLanguage())).getMessage(key);
        }
        if (message == null && !Objects.equals(locale, this.defaultLocale)) {
            message = this.getTable(this.defaultLocale).getMessage(key);
        }
        return message;
    }

    @NotNull
    public LanguageTable getTable(@NotNull Locale locale) {
        return this.tables.computeIfAbsent(locale, LanguageTable::new);
    }
}

