/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.RootCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class BukkitRootCommand
extends Command
implements RootCommand {
    private final BukkitCommandManager manager;
    private final String name;
    private BaseCommand defCommand;
    private Map<String, BaseCommand> subCommands = new HashMap<String, BaseCommand>();
    private List<BaseCommand> children = new ArrayList<BaseCommand>();
    boolean isRegistered = false;

    BukkitRootCommand(BukkitCommandManager manager, String name) {
        super(name);
        this.manager = manager;
        this.name = name;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return this.tabComplete(new BukkitCommandIssuer(this.manager, sender), alias, args);
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        return this.execute(new BukkitCommandIssuer(this.manager, sender), commandLabel, args);
    }

    private List<String> tabComplete(CommandIssuer sender, String alias, String[] args) throws IllegalArgumentException {
        HashSet completions = new HashSet();
        this.children.forEach(child -> completions.addAll(child.tabComplete(sender, alias, args)));
        return new ArrayList<String>(completions);
    }

    private boolean execute(CommandIssuer sender, String commandLabel, String[] args) {
        for (int i = args.length; i >= 0; --i) {
            String checkSub = StringUtils.join((Object[])args, (String)" ", (int)0, (int)i).toLowerCase();
            BaseCommand subHandler = this.subCommands.get(checkSub);
            if (subHandler == null) continue;
            subHandler.execute(sender, commandLabel, args);
            return true;
        }
        this.defCommand.execute(sender, commandLabel, args);
        return true;
    }

    @Override
    public void addChild(BaseCommand command) {
        if (this.defCommand == null || !command.subCommands.get((Object)"__default").isEmpty()) {
            this.defCommand = command;
            this.setPermission(command.permission);
        }
        this.addChildShared(this.children, this.subCommands, command);
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }
}

