/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandCompletionContext;
import co.aikar.commands.BukkitCommandCompletions;
import co.aikar.commands.BukkitCommandContexts;
import co.aikar.commands.BukkitCommandExecutionContext;
import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.BukkitMessageFormatter;
import co.aikar.commands.BukkitRegisteredCommand;
import co.aikar.commands.BukkitRootCommand;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageType;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.apachecommonslang.ApacheCommonsExceptionUtil;
import co.aikar.timings.lib.MCTiming;
import co.aikar.timings.lib.TimingManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public class BukkitCommandManager
extends CommandManager {
    protected final Plugin plugin;
    private final CommandMap commandMap;
    private final TimingManager timingManager;
    protected Map<String, Command> knownCommands = new HashMap<String, Command>();
    protected Map<String, BukkitRootCommand> registeredCommands = new HashMap<String, BukkitRootCommand>();
    protected BukkitCommandContexts contexts;
    protected BukkitCommandCompletions completions;
    MCTiming commandTiming;

    public BukkitCommandManager(Plugin plugin) {
        this.plugin = plugin;
        String pluginName = "acf-" + plugin.getDescription().getName();
        this.locales.addMessageBundles("acf-minecraft", pluginName, pluginName.toLowerCase());
        this.timingManager = TimingManager.of(plugin);
        this.commandTiming = this.timingManager.of("Commands");
        Object commandMap = null;
        try {
            Server server = Bukkit.getServer();
            Method getCommandMap = server.getClass().getDeclaredMethod("getCommandMap", new Class[0]);
            getCommandMap.setAccessible(true);
            commandMap = (CommandMap)getCommandMap.invoke((Object)server, new Object[0]);
            if (!SimpleCommandMap.class.isAssignableFrom(commandMap.getClass())) {
                this.log(LogLevel.ERROR, "ERROR: CommandMap has been hijacked! Offending command map is located at: " + commandMap.getClass().getName());
                this.log(LogLevel.ERROR, "We are going to try to hijack it back and resolve this, but you are now in dangerous territory.");
                this.log(LogLevel.ERROR, "We can not guarantee things are going to work.");
                Field cmField = server.getClass().getDeclaredField("commandMap");
                commandMap = new ProxyCommandMap((CommandMap)commandMap);
                cmField.set(server, commandMap);
                this.log(LogLevel.INFO, "Injected Proxy Command Map... good luck...");
            }
            Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommands.setAccessible(true);
            this.knownCommands = (Map)knownCommands.get(commandMap);
        }
        catch (Exception e) {
            this.log(LogLevel.ERROR, "Failed to get Command Map. ACF will not function.");
            ACFUtil.sneaky(e);
        }
        this.commandMap = commandMap;
        this.formatters.put(MessageType.ERROR, new BukkitMessageFormatter(ChatColor.RED, ChatColor.YELLOW, ChatColor.RED));
        this.formatters.put(MessageType.SYNTAX, new BukkitMessageFormatter(ChatColor.YELLOW, ChatColor.GREEN, ChatColor.WHITE));
        this.formatters.put(MessageType.INFO, new BukkitMessageFormatter(ChatColor.BLUE, ChatColor.DARK_GREEN, ChatColor.GREEN));
        Bukkit.getPluginManager().registerEvents((Listener)new ACFBukkitListener(plugin), plugin);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isCommandIssuer(Class<?> type) {
        return CommandSender.class.isAssignableFrom(type);
    }

    public synchronized CommandContexts<BukkitCommandExecutionContext> getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = new BukkitCommandContexts(this);
        }
        return this.contexts;
    }

    public synchronized CommandCompletions<BukkitCommandCompletionContext> getCommandCompletions() {
        if (this.completions == null) {
            this.completions = new BukkitCommandCompletions(this);
        }
        return this.completions;
    }

    @Override
    public boolean hasRegisteredCommands() {
        return !this.registeredCommands.isEmpty();
    }

    public void registerCommand(BaseCommand command, boolean force) {
        String plugin = this.plugin.getName().toLowerCase();
        command.onRegister(this);
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase();
            BukkitRootCommand bukkitCommand = (BukkitRootCommand)entry.getValue();
            if (!bukkitCommand.isRegistered) {
                if (force && this.knownCommands.containsKey(commandName)) {
                    this.commandMap.getCommand(commandName).unregister(this.commandMap);
                    this.knownCommands.remove(commandName);
                }
                this.commandMap.register(commandName, plugin, (Command)bukkitCommand);
            }
            bukkitCommand.isRegistered = true;
            this.registeredCommands.put(commandName, bukkitCommand);
        }
    }

    @Override
    public void registerCommand(BaseCommand command) {
        this.registerCommand(command, false);
    }

    public void unregisterCommand(BaseCommand command) {
        for (RootCommand rootcommand : command.registeredCommands.values()) {
            BukkitRootCommand bukkitCommand = (BukkitRootCommand)rootcommand;
            if (bukkitCommand.isRegistered) {
                this.unregisterCommand(bukkitCommand);
            }
            bukkitCommand.isRegistered = false;
        }
    }

    public void unregisterCommand(BukkitRootCommand command) {
        String plugin = this.plugin.getName().toLowerCase();
        command.unregister(this.commandMap);
        String key = command.getName();
        Command registered = this.knownCommands.get(key);
        if (command.equals(registered)) {
            this.knownCommands.remove(key);
        }
        this.knownCommands.remove(plugin + ":" + key);
    }

    public void unregisterCommands() {
        for (Map.Entry<String, BukkitRootCommand> entry : this.registeredCommands.entrySet()) {
            this.unregisterCommand(entry.getValue());
        }
    }

    public TimingManager getTimings() {
        return this.timingManager;
    }

    @Override
    public RootCommand createRootCommand(String cmd) {
        return new BukkitRootCommand(this, cmd);
    }

    @Override
    public CommandIssuer getCommandIssuer(Object issuer) {
        if (!(issuer instanceof CommandSender)) {
            throw new IllegalArgumentException(issuer.getClass().getName() + " is not a Command Issuer.");
        }
        return new BukkitCommandIssuer(this, (CommandSender)issuer);
    }

    @Override
    public <R extends CommandExecutionContext> R createCommandContext(RegisteredCommand command, Parameter parameter, CommandIssuer sender, List<String> args, int i, Map<String, Object> passedArgs) {
        return (R)new BukkitCommandExecutionContext(command, parameter, (BukkitCommandIssuer)sender, args, i, passedArgs);
    }

    @Override
    public CommandCompletionContext createCompletionContext(RegisteredCommand command, CommandIssuer sender, String input, String config, String[] args) {
        return new BukkitCommandCompletionContext(command, sender, input, config, args);
    }

    @Override
    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new BukkitRegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        Logger logger = this.plugin.getLogger();
        Level logLevel = level == LogLevel.INFO ? Level.INFO : Level.SEVERE;
        logger.log(logLevel, "[ACF] " + message);
        if (throwable != null) {
            for (String line : ACFPatterns.NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(throwable))) {
                logger.log(logLevel, "[ACF] " + line);
            }
        }
    }

    class ProxyCommandMap
    extends SimpleCommandMap {
        CommandMap proxied;

        ProxyCommandMap(CommandMap proxied) {
            super(Bukkit.getServer());
            this.proxied = proxied;
        }

        public void registerAll(String fallbackPrefix, List<Command> commands) {
            this.proxied.registerAll(fallbackPrefix, commands);
        }

        public boolean register(String label, String fallbackPrefix, Command command) {
            if (this.isOurCommand(command)) {
                return super.register(label, fallbackPrefix, command);
            }
            return this.proxied.register(label, fallbackPrefix, command);
        }

        boolean isOurCommand(String cmdLine) {
            String[] args = ACFPatterns.SPACE.split(cmdLine);
            return args.length != 0 && this.isOurCommand((Command)this.knownCommands.get(args[0].toLowerCase(Locale.ENGLISH)));
        }

        boolean isOurCommand(Command command) {
            return command instanceof RootCommand && ((RootCommand)command).getManager() == BukkitCommandManager.this;
        }

        public boolean register(String fallbackPrefix, Command command) {
            if (this.isOurCommand(command)) {
                return super.register(fallbackPrefix, command);
            }
            return this.proxied.register(fallbackPrefix, command);
        }

        public boolean dispatch(CommandSender sender, String cmdLine) throws CommandException {
            if (this.isOurCommand(cmdLine)) {
                return super.dispatch(sender, cmdLine);
            }
            return this.proxied.dispatch(sender, cmdLine);
        }

        public void clearCommands() {
            super.clearCommands();
            this.proxied.clearCommands();
        }

        public Command getCommand(String name) {
            if (this.isOurCommand(name)) {
                return super.getCommand(name);
            }
            return this.proxied.getCommand(name);
        }

        public List<String> tabComplete(CommandSender sender, String cmdLine) throws IllegalArgumentException {
            if (this.isOurCommand(cmdLine)) {
                return super.tabComplete(sender, cmdLine);
            }
            return this.proxied.tabComplete(sender, cmdLine);
        }
    }

    private class ACFBukkitListener
    implements Listener {
        private final Plugin plugin;

        public ACFBukkitListener(Plugin plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (!this.plugin.getName().equalsIgnoreCase(event.getPlugin().getName())) {
                return;
            }
            BukkitCommandManager.this.unregisterCommands();
        }
    }
}

