/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import co.aikar.locales.LocaleManager;
import co.aikar.locales.MessageKey;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Locales {
    private static final Locale[] CORE_LANGUAGES = new Locale[]{Locale.ENGLISH};
    private final CommandManager manager;
    private final LocaleManager<CommandIssuer> localeManager;

    Locales(CommandManager manager) {
        this.manager = manager;
        this.localeManager = LocaleManager.create(manager.getClass(), manager::getIssuerLocale);
        this.localeManager.addMessageBundles("acf-core");
    }

    public Locale getDefaultLocale() {
        return this.localeManager.getDefaultLocale();
    }

    public void addMessageBundles(String ... bundleNames) {
        for (String bundleName : bundleNames) {
            this.localeManager.addMessageBundles(bundleName);
        }
    }

    public void addMessageBundle(String bundleName, Locale locale) {
        this.localeManager.addMessageBundle(bundleName, locale);
    }

    public void addMessages(Locale locale, @NotNull Map<MessageKey, String> messages) {
        this.localeManager.addMessages(locale, messages);
    }

    public String addMessage(Locale locale, MessageKey key, String message) {
        return this.localeManager.addMessage(locale, key, message);
    }

    public String getMessage(CommandIssuer issuer, MessageKey key) {
        String message = this.localeManager.getMessage(issuer, key);
        if (message == null) {
            this.manager.log(LogLevel.ERROR, "Missing Language Key: " + key.getKey());
            message = "<MISSING_LANGUAGE_KEY:" + key.getKey() + ">";
        }
        return message;
    }
}

