/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandPermissionResolver;
import co.aikar.commands.JDACommandManager;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import org.jetbrains.annotations.NotNull;

public class JDACommandEvent
implements CommandIssuer {
    private MessageReceivedEvent event;
    private JDACommandManager manager;

    public JDACommandEvent(JDACommandManager manager, MessageReceivedEvent event) {
        this.manager = manager;
        this.event = event;
    }

    public MessageReceivedEvent getEvent() {
        return this.event;
    }

    public MessageReceivedEvent getIssuer() {
        return this.event;
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isPlayer() {
        return false;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        long authorId = this.event.getAuthor().getIdLong();
        return new UUID(0L, authorId);
    }

    @Override
    public boolean hasPermission(String permission) {
        CommandPermissionResolver permissionResolver = this.manager.getPermissionResolver();
        return permissionResolver == null || permissionResolver.hasPermission(this.manager, this, permission);
    }

    @Override
    public void sendMessageInternal(String message) {
        this.event.getChannel().sendMessage((CharSequence)message).queue();
    }

    public void sendMessage(Message message) {
        this.event.getChannel().sendMessage(MessageCreateData.fromMessage((Message)message)).queue();
    }

    public void sendMessage(MessageEmbed message) {
        this.event.getChannel().sendMessage(MessageCreateData.fromEmbeds((MessageEmbed[])new MessageEmbed[]{message})).queue();
    }
}

