/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFLog;
import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.annotation.Single;
import co.aikar.commands.annotation.Split;
import co.aikar.commands.annotation.Values;
import co.aikar.commands.contexts.ContextResolver;
import co.aikar.commands.contexts.SenderAwareContextResolver;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;

public class CommandContexts {
    private final Map<Class<?>, ContextResolver<?>> contextMap = Maps.newHashMap();

    CommandContexts() {
        this.registerContext(Integer.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).intValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument("Must be a number");
            }
        });
        this.registerContext(Long.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).longValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument("Must be a number");
            }
        });
        this.registerContext(Float.class, c -> {
            try {
                return Float.valueOf(ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).floatValue());
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument("Must be a number");
            }
        });
        this.registerContext(Double.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes")).doubleValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument("Must be a number");
            }
        });
        this.registerContext(Number.class, c -> {
            try {
                return ACFUtil.parseNumber(c.popFirstArg(), c.hasFlag("suffixes"));
            }
            catch (NumberFormatException e) {
                throw new InvalidCommandArgument("Must be a number");
            }
        });
        this.registerContext(Boolean.class, c -> ACFUtil.isTruthy(c.popFirstArg()));
        this.registerContext(String.class, c -> {
            Values values = c.getParam().getAnnotation(Values.class);
            if (values != null) {
                return c.popFirstArg();
            }
            if (c.isLastArg() && c.getParam().getAnnotation(Single.class) == null) {
                return ACFUtil.join(c.getArgs());
            }
            return c.popFirstArg();
        });
        this.registerContext(String[].class, c -> {
            String val = c.isLastArg() && c.getParam().getAnnotation(Single.class) == null ? ACFUtil.join(c.getArgs()) : c.popFirstArg();
            Split split = c.getParam().getAnnotation(Split.class);
            if (split != null) {
                if (val.isEmpty()) {
                    throw new InvalidCommandArgument();
                }
                return ACFPatterns.getPattern(split.value()).split(val);
            }
            if (!c.isLastArg()) {
                ACFUtil.sneaky((Throwable)new InvalidConfigurationException("Weird Command signature... String[] should be last or @Split"));
            }
            String[] result = c.getArgs().toArray(new String[c.getArgs().size()]);
            c.getArgs().clear();
            return result;
        });
        this.registerContext(Enum.class, c -> {
            String first = c.popFirstArg();
            Class<?> enumCls = c.getParam().getType();
            Enum<?> match = ACFUtil.simpleMatch(enumCls, first);
            if (match == null) {
                List<String> names = ACFUtil.enumNames(enumCls);
                throw new InvalidCommandArgument("Please specify one of: " + ACFUtil.join(names));
            }
            return match;
        });
    }

    public <T> void registerSenderAwareContext(Class<T> context, SenderAwareContextResolver<T> supplier) {
        this.contextMap.put(context, supplier);
    }

    public <T> void registerContext(Class<T> context, ContextResolver<T> supplier) {
        this.contextMap.put(context, supplier);
    }

    public ContextResolver<?> getResolver(Class<?> type) {
        Class<?> rootType = type;
        while (type != Object.class) {
            ContextResolver<?> resolver = this.contextMap.get(type);
            if (resolver != null) {
                return resolver;
            }
            if ((type = type.getSuperclass()) != null) continue;
        }
        ACFLog.exception((Throwable)new InvalidConfigurationException("No context resolver defined for " + rootType.getName()));
        return null;
    }
}

