/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.command.CommandSender;

public class CommandCompletions {
    private Map<String, CommandCompletionHandler> completionMap = new HashMap<String, CommandCompletionHandler>();

    public CommandCompletions() {
        this.registerCompletion("range", (sender, completionConfig, input) -> {
            int end;
            int start;
            if (completionConfig == null) {
                return ImmutableList.of();
            }
            String[] ranges = ACFPatterns.DASH.split(completionConfig);
            if (ranges.length != 2) {
                start = 0;
                end = ACFUtil.parseInt(ranges[0], 0);
            } else {
                start = ACFUtil.parseInt(ranges[0], 0);
                end = ACFUtil.parseInt(ranges[1], 0);
            }
            return IntStream.rangeClosed(start, end).mapToObj(Integer::toString).collect(Collectors.toList());
        });
        this.registerCompletion("timeunits", (sender, completionConfig, input) -> ImmutableList.of((Object)"minutes", (Object)"hours", (Object)"days", (Object)"weeks", (Object)"months", (Object)"years"));
    }

    public CommandCompletionHandler registerCompletion(String id, CommandCompletionHandler handler) {
        return this.completionMap.put("@" + id.toLowerCase(), handler);
    }

    public List<String> of(CommandSender sender, String completion, String input) {
        String[] complete;
        CommandCompletionHandler handler;
        if (completion == null) {
            return ImmutableList.of();
        }
        if (input == null) {
            input = "";
        }
        if ((handler = this.completionMap.get((complete = ACFPatterns.COLON.split(completion, 2))[0].toLowerCase())) != null) {
            List<String> completions = handler.getCompletions(sender, complete.length == 1 ? null : complete[1], input);
            if (completions == null) {
                return ImmutableList.of();
            }
            return completions;
        }
        return Lists.newArrayList((Object[])ACFPatterns.PIPE.split(completion));
    }

    public static interface CommandCompletionHandler {
        public List<String> getCompletions(CommandSender var1, String var2, String var3);
    }
}

