/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandCompletions;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class BukkitCommandCompletions
extends CommandCompletions {
    BukkitCommandCompletions() {
        this.registerCompletion("mobs", (sender, completionConfig, input) -> {
            Stream<String> normal = Stream.of(EntityType.values()).map(entityType -> ACFUtil.simplifyString(entityType.getName()));
            return normal.collect(Collectors.toList());
        });
        this.registerCompletion("worlds", (sender, completionConfig, input) -> Bukkit.getWorlds().stream().map(World::getName).collect(Collectors.toList()));
        this.registerCompletion("players", (sender, completionConfig, input) -> {
            Validate.notNull((Object)sender, (String)"Sender cannot be null");
            Player senderPlayer = sender instanceof Player ? (Player)sender : null;
            ArrayList<String> matchedPlayers = new ArrayList<String>();
            for (Player player : sender.getServer().getOnlinePlayers()) {
                String name = player.getName();
                if (senderPlayer != null && !senderPlayer.canSee(player) || !StringUtil.startsWithIgnoreCase((String)name, (String)input)) continue;
                matchedPlayers.add(name);
            }
            matchedPlayers.sort(String.CASE_INSENSITIVE_ORDER);
            return matchedPlayers;
        });
    }
}

